package com.jiangjl.concurrency.actor.isolatedmutable.actor;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.jiangjl.concurrency.actor.isolatedmutable.domain.SimpleEmployee;
import com.jiangjl.concurrency.actor.sharedmutable.domain.BriefNote;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class IMHostActor extends AbstractActor {

    private final ActorRef reportorRef;

    private LoggingAdapter logger = Logging.getLogger(getContext().system(), this);

    public IMHostActor() {
        this.reportorRef = getContext().actorOf(Props.create(ReportWorkYearActor.class), "employee-actor");
    }

    @Override
    public Receive createReceive() {
        return receiveBuilder().match(Integer.class, count -> {
            logger.info("total employee count: {}", count);

            BriefNote briefNote = new BriefNote();

            List<Future> futures = new ArrayList<>();
            for (int i = 0; i < count; i++) {
                futures.add(Patterns.ask(reportorRef, new SimpleEmployee(), Timeout.apply(1, TimeUnit.SECONDS)));
            }

            for (Future future : futures) {
                int workYear = (Integer) Await.result(future, Duration.apply(1, TimeUnit.SECONDS));
                briefNote.addYear("", workYear);
            }

            logger.info(briefNote.getResult());

        }).build();
    }
}
