package com.jiangjl.concurrency;

import com.jiangjl.concurrency.j.simple.RunnableEmployee;
import com.jiangjl.concurrency.spec.Recordable;
import com.jiangjl.concurrency.stm.sharedmutable.STMWhiteBoard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Main {


    private static ExecutorService executorService = Executors.newFixedThreadPool(10);

    private static Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws InterruptedException {
        Recordable whiteBoard = new STMWhiteBoard();

        for (int i = 0; i < 20; i++) {
            executorService.submit(new RunnableEmployee(whiteBoard));
        }

        executorService.shutdown();

        if (executorService.awaitTermination(20, TimeUnit.SECONDS)) {
            logger.info(whiteBoard.getResult());
        }

        System.exit(1);
    }
}
