package com.jiangjl.concurrency.actor.sharedmutable.actor;

import akka.actor.AbstractActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.jiangjl.concurrency.actor.sharedmutable.domain.EmployeeWithNote;
import com.jiangjl.concurrency.spec.Employee;
import com.jiangjl.concurrency.utils.RandomUtils;

public class EmployeeWithNoteActor extends AbstractActor implements Employee {

    private LoggingAdapter logger = Logging.getLogger(getContext().system(), this);

    @Override
    public Receive createReceive() {
        return receiveBuilder().match(EmployeeWithNote.class, employee -> {
            employee.getBriefNote().addYear(employee.getName(), employee.getWorkYear());
            getSender().tell(employee.getBriefNote(), getSelf());
            logger.info("add {} work year {}, and return briefNote", employee.getName(), employee.getWorkYear());
        }).build();
    }

    @Override
    public String getName() {
        return RandomUtils.randomName();
    }

    @Override
    public Integer getWorkYear() {
        return RandomUtils.randomYear();
    }
}
