package com.jiangjl.concurrency.actor.sharedmutable.domain;

import com.jiangjl.concurrency.spec.Employee;
import com.jiangjl.concurrency.utils.RandomUtils;

public class EmployeeWithNote implements Employee {

    private final String name;
    private final Integer workYear;
    private final BriefNote briefNote;

    public EmployeeWithNote(BriefNote briefNote) {
        this.name = RandomUtils.randomName();
        this.workYear = RandomUtils.randomYear();
        this.briefNote = briefNote;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Integer getWorkYear() {
        return workYear;
    }

    public BriefNote getBriefNote() {
        return briefNote;
    }
}
