package com.jiangjl.concurrency.j.isolatedmutable;

import com.jiangjl.concurrency.j.simple.SimpleWhiteBoard;
import com.jiangjl.concurrency.spec.Employee;
import com.jiangjl.concurrency.spec.Recordable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class IsolatedMutableMain {


    private static ExecutorService executorService = Executors.newFixedThreadPool(10);

    private static Logger logger = LoggerFactory.getLogger(IsolatedMutableMain.class);

    public static void main(String[] args) throws InterruptedException {

        Recordable whiteBoard = new SimpleWhiteBoard();

        List<Future> futureList = new ArrayList<>();

        for (int i = 0; i < 200; i++) {
            futureList.add(executorService.submit(new IMEmployee()));
        }

        futureList.forEach(f -> {
            try {
                Employee employee = (Employee) f.get(200, TimeUnit.MILLISECONDS);
                whiteBoard.addYear(employee.getName(), employee.getWorkYear());
            } catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
            }
        });

        logger.info(whiteBoard.getResult());

        System.exit(1);
    }
}
