package com.jiangjl.concurrency.j.sharedmutable.lock;

import com.jiangjl.concurrency.spec.Recordable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.locks.ReentrantLock;


public class WhiteBoardWithLock implements Recordable {
    private static Logger logger = LoggerFactory.getLogger(WhiteBoardWithLock.class);
    private final ReentrantLock lock = new ReentrantLock();
    private Integer count = 0;
    private Integer totalYears = 0;

    @Override
    public void addYear(String name, Integer years) {
        lock.lock();
        try {
            Thread.sleep(50);
            count = count + 1;
            totalYears = totalYears + years;
            logger.info("seq:{}, {} add {} years, total {}", count, name, years, totalYears);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            lock.unlock();
        }
    }

    @Override
    public String getResult() {
        return toString();
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("WhiteBoardWithLock{");
        sb.append("count=").append(count);
        sb.append(", totalYears=").append(totalYears);
        sb.append('}');
        return sb.toString();
    }
}
