package com.jiangjl.concurrency.j.sharedmutable.sync;

import com.jiangjl.concurrency.spec.Recordable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class WhiteBoardWithSync implements Recordable {
    private static Logger logger = LoggerFactory.getLogger(WhiteBoardWithSync.class);
    private Integer count = 0;
    private Integer totalYears = 0;

    @Override
    public synchronized void addYear(String name, Integer years) {
        try {
            Thread.sleep(50);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        count = count + 1;
        totalYears = totalYears + years;
        logger.info("seq:{}, {} add {} years, total {}", count, name, years, totalYears);
    }

    @Override
    public String getResult() {
        return toString();
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("WhiteBoardWithSync{");
        sb.append("count=").append(count);
        sb.append(", totalYears=").append(totalYears);
        sb.append('}');
        return sb.toString();
    }
}
