package com.jiangjl.concurrency.j.simple;

import com.jiangjl.concurrency.spec.Employee;
import com.jiangjl.concurrency.spec.Recordable;
import com.jiangjl.concurrency.utils.RandomUtils;

public class RunnableEmployee implements Employee, Runnable {

    private String name;
    private Integer workYear;

    private Recordable whiteBoard;

    public RunnableEmployee(Recordable whiteBoard) {
        this.name = RandomUtils.randomName();
        this.workYear = RandomUtils.randomYear();
        this.whiteBoard = whiteBoard;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Integer getWorkYear() {
        return workYear;
    }

    @Override
    public void run() {
        whiteBoard.addYear(name, workYear);
    }
}
