package com.jiangjl.concurrency.stm.sharedmutable;

import com.jiangjl.concurrency.spec.Recordable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.japi.STM;

import static scala.concurrent.stm.japi.STM.afterCommit;
import static scala.concurrent.stm.japi.STM.afterRollback;
import static scala.concurrent.stm.japi.STM.atomic;

public class STMWhiteBoard implements Recordable {

    private static Logger logger = LoggerFactory.getLogger(STMWhiteBoard.class);

    private final Ref.View<Integer> countRef = STM.newRef(0);
    private final Ref.View<Integer> totalYearRef = STM.newRef(0);

    @Override
    public void addYear(String name, Integer years) {
        atomic(() -> {
                    try {
                        Thread.sleep(20);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Integer count = countRef.get() + 1;
                    Integer totalYears = totalYearRef.get() + years;

                    countRef.swap(count);
                    totalYearRef.swap(totalYears);
                    logger.info("seq:{}, {} add {} years, total {}", count, name, years, totalYears);

                    afterCommit(() -> logger.info("seq:{}, {} commit", count, name));
                    afterRollback(() -> logger.info("seq:{}, {} rollback", count, name));
                }
        );
    }

    @Override
    public String getResult() {
        final StringBuffer sb = new StringBuffer("SimpleWhiteBoard{");
        sb.append("count=").append(countRef.get());
        sb.append(", totalYears=").append(totalYearRef.get());
        sb.append('}');
        return sb.toString();
    }
}
