package com.jiangjl.concurrency.actor.immutable.actor;

import akka.actor.AbstractActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.jiangjl.concurrency.actor.immutable.domain.EmployeeWIthPreTotalYear;
import com.jiangjl.concurrency.spec.Employee;
import com.jiangjl.concurrency.utils.RandomUtils;

public class CalculateActor extends AbstractActor implements Employee {

    private LoggingAdapter logger = Logging.getLogger(getContext().system(), this);

    @Override
    public Receive createReceive() {
        return receiveBuilder().match(EmployeeWIthPreTotalYear.class, employee -> {
            getSender().tell(employee.getWorkYear() + employee.getPreTotalYear(), getSelf());
            logger.info("{} add work year {} to pre total year {}", employee.getName(), employee.getWorkYear(), employee.getPreTotalYear());
        }).build();
    }

    @Override
    public String getName() {
        return RandomUtils.randomName();
    }

    @Override
    public Integer getWorkYear() {
        return RandomUtils.randomYear();
    }
}
