package com.jiangjl.concurrency.actor.immutable.actor;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.jiangjl.concurrency.actor.immutable.domain.EmployeeWIthPreTotalYear;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

import java.util.concurrent.TimeUnit;

public class IHostActor extends AbstractActor {

    private final ActorRef calculateRef;

    private LoggingAdapter logger = Logging.getLogger(getContext().system(), this);

    public IHostActor() {
        this.calculateRef = getContext().actorOf(Props.create(CalculateActor.class), "employee-actor");
    }

    @Override
    public Receive createReceive() {
        return receiveBuilder().match(Integer.class, count -> {
            logger.info("total employee count: {}", count);

            Integer totalYear = 0;

            for (int i = 0; i < count; i++) {
                Future future = Patterns.ask(calculateRef, new EmployeeWIthPreTotalYear(totalYear), Timeout.apply(1, TimeUnit.SECONDS));
                totalYear = (Integer) Await.result(future, Duration.apply(1, TimeUnit.SECONDS));
            }

            logger.info("count {}, result: {}", totalYear);

        }).build();
    }
}
