package com.jiangjl.concurrency.actor.isolatedmutable.actor;

import akka.actor.AbstractActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.jiangjl.concurrency.actor.isolatedmutable.domain.SimpleEmployee;
import com.jiangjl.concurrency.spec.Employee;
import com.jiangjl.concurrency.utils.RandomUtils;

public class ReportWorkYearActor extends AbstractActor implements Employee {

    private LoggingAdapter logger = Logging.getLogger(getContext().system(), this);

    @Override
    public Receive createReceive() {
        return receiveBuilder().match(SimpleEmployee.class, employee -> {

            getSender().tell(employee.getWorkYear(), getSelf());
            logger.info("{} report work year {}", employee.getName(), employee.getWorkYear());
        }).build();
    }

    @Override
    public String getName() {
        return RandomUtils.randomName();
    }

    @Override
    public Integer getWorkYear() {
        return RandomUtils.randomYear();
    }
}
