package com.jiangjl.concurrency.actor.sharedmutable.actor;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.jiangjl.concurrency.actor.sharedmutable.domain.BriefNote;
import com.jiangjl.concurrency.actor.sharedmutable.domain.EmployeeWithNote;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

import java.util.concurrent.TimeUnit;

public class SMHostActor extends AbstractActor {

    private final ActorRef employeeActor;

    private LoggingAdapter logger = Logging.getLogger(getContext().system(), this);

    public SMHostActor() {
        this.employeeActor = getContext().actorOf(Props.create(EmployeeWithNoteActor.class), "employee-actor");
    }

    @Override
    public Receive createReceive() {
        return receiveBuilder().match(Integer.class, count -> {
            logger.info("total employee count: {}", count);

            BriefNote briefNote = new BriefNote();

            Future future;
            for (int i = 0; i < count; i++) {
                future = Patterns.ask(employeeActor, new EmployeeWithNote(briefNote), Timeout.apply(1, TimeUnit.SECONDS));
                briefNote = (BriefNote) Await.result(future, Duration.apply(1, TimeUnit.SECONDS));
            }

            logger.info(briefNote.getResult());

        }).build();
    }
}
