package com.jiangjl.concurrency.actor.sharedmutable.domain;

import com.jiangjl.concurrency.spec.Recordable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BriefNote implements Recordable {

    private static Logger logger = LoggerFactory.getLogger(BriefNote.class);
    private Integer count = 0;
    private Integer totalYears = 0;

    @Override
    public void addYear(String name, Integer years) {
        try {
            Thread.sleep(50);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        count = count + 1;
        totalYears = totalYears + years;
        logger.info("seq:{}, {} add {} years, total {}", count, name, years, totalYears);
    }

    @Override
    public String getResult() {
        final StringBuffer sb = new StringBuffer("BriefNote{");
        sb.append("count=").append(count);
        sb.append(", totalYears=").append(totalYears);
        sb.append('}');
        return sb.toString();
    }
}
