package com.jiangjl.concurrency.j.isolatedmutable;

import com.jiangjl.concurrency.spec.Employee;
import com.jiangjl.concurrency.utils.RandomUtils;

import java.util.concurrent.Callable;

public class IMEmployee implements Employee, Callable<Employee> {

    private String name;
    private Integer workYear;

    public IMEmployee() {
        this.name = RandomUtils.randomName();
        this.workYear = RandomUtils.randomYear();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Integer getWorkYear() {
        return workYear;
    }


    @Override
    public Employee call() throws Exception {
        return this;
    }
}
