package com.common.toolbox.app_utils;

import android.text.TextUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import okhttp3.FormBody;
import okhttp3.Request;

/**
 * @author Mansoul
 * @create 2019/7/1 12:04
 * @des
 */
public class HeadersUtil {


    public static void signHeader(String signKey,
                                  String deviceSign,
                                  String sdSign,
                                  Request request,
                                  Request.Builder builder) {
        try {
            String random = UUID.randomUUID().toString();

            //请求参数名参数值+appsecret+random
            String sign = "";
            String params = "";
            if (TextUtils.equals(request.method(), "GET")) {
                //参数名列表
                List<String> paramNames = new ArrayList<>(request.url().queryParameterNames());

                List<String> paramsKey = new ArrayList<>();
                HashMap<String, String> paramsMap = new HashMap<>();
                for (int i = 0; i < paramNames.size(); i++) {
                    String key = paramNames.get(i);
                    paramsKey.add(key);
                    paramsMap.put(key, request.url().queryParameterValue(i));
                }
                params = getParameter(paramsKey, paramsMap);
            } else if (TextUtils.equals(request.method(), "POST") || TextUtils.equals(request.method(), "PUT")) {
                if (request.body() instanceof FormBody) {
                    FormBody body = (FormBody) request.body();
                    List<String> paramsKey = new ArrayList();
                    HashMap<String, String> paramsMap = new HashMap<>();
                    for (int i = 0; i < body.size(); i++) {
                        paramsKey.add(body.encodedName(i));
                        paramsMap.put(body.encodedName(i), body.encodedValue(i));
                    }
                    params = getParameter(paramsKey, paramsMap);
                }
                if (request.url().queryParameterNames() != null) {
                    List<String> paramNames = new ArrayList<>(request.url().queryParameterNames());
                    List<String> paramsKey = new ArrayList<>();
                    HashMap<String, String> paramsMap = new HashMap<>();
                    for (int i = 0; i < paramNames.size(); i++) {
                        String key = paramNames.get(i);
                        paramsKey.add(key);
                        paramsMap.put(key, request.url().queryParameterValue(i));
                    }
                    params = params + "&" + getParameter(paramsKey, paramsMap);
                    if (params.startsWith("&")) {
                        params = params.replaceFirst("&", "");
                    }
                    if (params.endsWith("&")) {
                        params += "!";
                        params = params.replace("&!", "");
                    }
                }
            }
            String sdDeviceSign = "";
            if (!TextUtils.isEmpty(deviceSign) && !TextUtils.isEmpty(sdSign)) {
                sdDeviceSign = "deviceSign=" + deviceSign + "&sdSign=" + sdSign;
            }
            if (!TextUtils.isEmpty(sdDeviceSign) && !TextUtils.isEmpty(params)) {
                params = "&" + params;
            }
            sign = sdDeviceSign + params + signKey + random;
            System.out.println("http sign:" + sign);
            builder.addHeader("X-APP-SIGN", MD5Helper.md5Hex(sign));
            System.out.println("http sign md5Hex:" + MD5Helper.md5Hex(sign));
            builder.addHeader("X-APP-RANDOM", random);
            builder.addHeader("X-DEVICE-SIGN", deviceSign);
            builder.addHeader("X-SD-SIGN", sdSign);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getParameter(List<String> paramsKey, Map<String, String> params) {
        //排序
        Collections.sort(paramsKey);
        StringBuilder sb = new StringBuilder();
        for (String key : paramsKey) {
            try {
                String value = URLDecoder.decode(params.get(key), "UTF-8");
                sb.append(sb.length() == 0 ? (key + "=" + value) : ("&" + key + "=" + value));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}
