package com.common.toolbox.app_utils;

import android.text.TextUtils;
import android.util.Base64;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by SiKang on 2019/6/14.
 */
public class StringUtils {
    /**
     * MD5
     */
    public static String MD5(String key) {
        String cacheKey;
        try {
            final MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = bytesToHexString(mDigest.digest());
        } catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }


    /**
     * base64 解码
     */
    public static String fromBase64(String value) {
        if (!TextUtils.isEmpty(value))
            return new String(Base64.decode(value.getBytes(), Base64.DEFAULT));
        else
            return "";
    }

    /**
     * String转base64
     */
    public static String toBase64(String value) {
        byte[] bytes = value.getBytes();
        if (bytes != null && bytes.length > 0)
            return Base64.encodeToString(bytes, Base64.DEFAULT);
        else
            return "";
    }
}
