package com.common.toolbox.app_utils;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Base64;

import java.io.*;
import java.util.Locale;
import java.util.UUID;

/**
 * Created by SiKang on 2019/6/14.
 */
public class DeviceInfo {
    private static final String SIGN_PATH = Environment.getExternalStorageDirectory() + "/sw_config/device.json";
    //改强制改变系统语言之前，把系统默认语言记录下来
    public static String DEFAULT_LANGUAGE = "";
    public static String DEVICE_SIGN = "";
    public static String SD_SIGN = "";

    /**
     * 读取SD卡中的设备指纹
     */
    public static String getDeviceSignFromSD() {
        if (!TextUtils.isEmpty(SD_SIGN)) {
            return SD_SIGN;
        }
        String device_sign = "";
        File file = new File(SIGN_PATH);
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                device_sign = sb.toString();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //如果取不到就生成一个新的
        if (TextUtils.isEmpty(device_sign)) {
            device_sign = writeSDSign();
        }

        SD_SIGN = device_sign;
        return SD_SIGN;
    }

    /**
     * 在SD卡中保存一个设备指纹
     */
    private static String writeSDSign() {
        String uuid = UUID.randomUUID().toString();
        try {
            File dir = new File(Environment.getExternalStorageDirectory() + "/sw_config/");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(SIGN_PATH);
            if (!file.exists()) {
                file.createNewFile();
            }

            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            fw.flush();
            fw.write(uuid);
            fw.close();
            return uuid;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }


    /**
     * 根据硬件信息计算设备指纹
     */
    public static String getSignFromHardware() {
        if (!TextUtils.isEmpty(DEVICE_SIGN)) {
            return DEVICE_SIGN;
        }
        String device_id = Build.BOARD + Build.BRAND +
                Build.CPU_ABI + Build.DEVICE +
                Build.DISPLAY + Build.HOST +
                Build.ID + Build.MANUFACTURER +
                Build.MODEL + Build.PRODUCT +
                Build.TAGS + Build.TYPE +
                Build.USER;

        DEVICE_SIGN = StringUtils.MD5(device_id);
        return DEVICE_SIGN;
    }


    /**
     * 根据硬件信息计算设备指纹
     */
    public static String getHardwareInfo() {
        String hardwareInfo = "board=" + Build.BOARD + "&" +
                "brand=" + Build.BRAND + "&" +
                "cpu_abi=" + Build.CPU_ABI + "&" +
                "device=" + Build.DEVICE + "&" +
                "display=" + Build.DISPLAY + "&" +
                "host=" + Build.HOST + "&" +
                "id=" + Build.ID + "&" +
                "manufacturer=" + Build.MANUFACTURER + "&" +
                "model=" + Build.MODEL + "&" +
                "product=" + Build.PRODUCT + "&" +
                "tags=" + Build.TAGS + "&" +
                "type=" + Build.TYPE + "&" +
                "root=" + isRoot() + "&" +
                "user=" + Build.USER + "&" + DEFAULT_LANGUAGE;

        return hardwareInfo;
    }

    public static boolean isRoot() {
        try {
            return new File("/system/bin/su").exists() || new File("/system/xbin/su").exists();
        } catch (Exception e) {
            return false;
        }
    }

}
