package signal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;

/**
 * Created by SiKang on 2018/12/28.
 */
public class JNISignal {

    /**
     * 加载so库
     * */
    static {
        System.loadLibrary("signal");
    }

    /**
     * 获取暗号
     * */
    public static native String getSignal(Context context);

    /**
     * 获取当前签名的 hashCode
     * */
    public static int getKeyStoreHashCode(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(
                    context.getPackageName(), PackageManager.GET_SIGNATURES);
            Signature[] signs = packageInfo.signatures;
            Signature sign = signs[0];
            return sign.hashCode();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

}
