package com.common.activity;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.common.base.BaseActivity;
import com.common.bean.BankBean;
import com.common.bean.LoanInfo;
import com.common.widget.SpanButton;

import tech.starwin.R;
import tech.starwin.base.RecyclerViewHolder;
import tech.starwin.impl.OnEventClickListener;
import tech.starwin.mvp.presenter.UserPresenter;
import tech.starwin.utils.GeneralUtils;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.ui_utils.DialogFactory;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2020-03-04.
 */
public class ActivityBankInfo extends BaseActivity {
    private RecyclerViewHolder holder;
    SpanButton mBankNameBtn;
    TextView mBankNumberEt;
    LoanInfo loanInfo;
    Button mSubmitBtn;

    public static void start(Context context, String loanId) {
        new ActivityJumper.Builder(context, ActivityBankInfo.class).put("loanId", loanId).build().start();
    }

    @Override
    public int bindLayout() {
        return R.layout.activity_bank_info;
    }

    @Override
    public void initView() {
        mBankNameBtn = findViewById(R.id.activity_bank_baneName_btn);
        mBankNumberEt = findViewById(R.id.activity_bank_bankNumber_et);
        mSubmitBtn = findViewById(R.id.activity_bank_submit_btn);

        getPresenter(UserPresenter.class).getBankInfo("action_getBankAndLoanAmout");

        UIHelper.bindClickListener(new OnEventClickListener() {
            @Override
            public void onEventClick(View v) {
                int id = v.getId();
                if (id == R.id.activity_bank_baneName_btn) {
                    if (loanInfo != null && loanInfo.getBankNameArray() != null) {
                        DialogFactory.createMenuDialog(ActivityBankInfo.this, loanInfo.getBankNameArray(), (dialog, which) -> {
                            dialog.dismiss();
                            loanInfo.setBankCode(loanInfo.getBankList().get(which).getBankCode());
                            String bankName = loanInfo.getBankList().get(which).getBankName();
                            mBankNameBtn.setText(bankName);
                        }).show();
                    }
                } else if (id == R.id.activity_bank_submit_btn) {
                    String banNo = mBankNumberEt.getText().toString();

                    if (TextUtils.isEmpty(loanInfo.getBankCode()) || TextUtils.isEmpty(banNo)) {
                        DialogFactory.showMessageDialog(ActivityBankInfo.this, getString(R.string.input_invalid));
                        return;
                    }

                    getPresenter(UserPresenter.class).updateBankInfo("update_bankInfo",
                            getIntent().getStringExtra("loanId"), loanInfo.getBankCode(), banNo);
                }
            }
        }, mBankNameBtn, mSubmitBtn);
    }


    @Override
    public void onHttpSuccess(String action, Object result) {
        switch (action) {
            case "action_getBankAndLoanAmout":
                loanInfo = (LoanInfo) result;
                String bankName = getBankName(loanInfo, loanInfo.getUserBankInfo().getBankCode());
                mBankNameBtn.setText(bankName);
                mBankNumberEt.setText(loanInfo.getUserBankInfo().getCardNo());
                break;
            case "update_bankInfo":
                DialogFactory.createYesOrNoDialog(ActivityBankInfo.this, getString(R.string.update_bank_card_successful), (dialog, isAgree) -> {
                    dialog.dismiss();
                    finish();
                }).show();
                break;
        }
    }


    public String getBankName(LoanInfo loanInfo, String code) {
        if (!GeneralUtils.isEmpty(loanInfo.getBankList())) {
            for (BankBean bankBean : loanInfo.getBankList()) {
                if (bankBean.getBankCode().equals(code)) {
                    return bankBean.getBankName();
                }
            }
        }
        return "";
    }
}
