package tech.starwin.network;

import com.google.firebase.remoteconfig.FirebaseRemoteConfig;

import java.util.Arrays;
import java.util.List;

import tech.starwin.LibConfig;
import tech.starwin.mvp.beans.GatewayInfoBean;
import tech.starwin.utils.LogUtils;
import tech.starwin.utils.PreferencesManager;

/**
 * Created by SiKang on 2018/9/28.
 */
public class Gateway {
    private static GatewayInfoBean gatewayInfo;

    public static void init(GatewayInfoBean info) {
        gatewayInfo = info;
        if (gatewayInfo == null) {
            gatewayInfo = new GatewayInfoBean();
            gatewayInfo.gateway = Arrays.asList(LibConfig.GATEWAY_HOST_G0,
                    LibConfig.GATEWAY_HOST_G1);
            gatewayInfo.rest = Arrays.asList(LibConfig.API_BASE_URL);
            gatewayInfo.privacy = Arrays.asList(LibConfig.AGREEMENT_URL);
            gatewayInfo.admin = Arrays.asList(LibConfig.ADMIN_HOST);
            gatewayInfo.harvester = Arrays.asList(LibConfig.HARVESTER_IP + ":" + LibConfig.HARVESTER_PORT);
        }
    }

    /**
     * 更新gateway
     */
    public static void setGatewayInfoBean(GatewayInfoBean info) {
        gatewayInfo.notifyWith(info);
        PreferencesManager.get().saveGatewayInfo(info);
    }

    public static List<String> getGatewayUrl() {
        return gatewayInfo.gateway;
    }

    public static String getPrivacyUrl() {
        return gatewayInfo.privacy.get(0);
    }

    public static String getHarvesterUrl() {
        return gatewayInfo.harvester.get(0);
    }

    public static String getAdminUrl() {
        return gatewayInfo.admin.get(0);
    }

    public static String getRestUrl() {
        return gatewayInfo.rest.get(0);
    }

}
