package com.common.bean;

import android.os.Build;

import java.io.Serializable;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Created by SiKang on 2019-11-14.
 */
public class DeviceInfoBean implements Serializable {

    private int screenWidth;//"1080",

    private int screenHeight;//"1920",

    private String androidId;

    private String country;//"国家 Locale.getCountry()",

    private String language;//"语言 Locale.getLanguage()",

    private String displayCountry;//"国家展示文案 Locale.getDisplayCountry()",

    private String displayLanguage;//"语言展示文案 defaultLocale.getDisplayLanguage()",

    private String displayName;//"Locale.getDisplayName()",

    private String city;//"地区 timeZone.getID()",

    private String timeZoneShort;//"时区简写 timeZone.getDisplayName(false, TimeZone.SHORT)",

    private String timeZoneLong;//"时区全称 timeZone.getDisplayName(false, TimeZone.LONG);",

    private String timezone;//时区(GMT+08:00)

    private String board = Build.BOARD; //主板

    private String brand = Build.BRAND; //品牌

    private String host = Build.HOST;

    private String id = Build.ID;

    private String manufacturer = Build.MANUFACTURER;//手机厂商(huawei)

    private String modelNo = Build.MODEL; //型号

    private String product = Build.PRODUCT;

    private String cpuAbi = Build.CPU_ABI; //cpu架构

    private String device = Build.DEVICE;

    private long time = Build.TIME;

    private int sdkVersion = Build.VERSION.SDK_INT; //SDK版本

    private String osVersion = Build.VERSION.RELEASE; //Android版本

    private String fingerPrint = Build.FINGERPRINT;//手机信息采集(HUAWEI/VNS-L31/HWVNS-H:6.0/HUAWEIVNS-L31/C636B170:user/release-keys)

    private String display = Build.DISPLAY;

    private String hardware = Build.HARDWARE;

    private String serialNo = Build.SERIAL;

    private String tags = Build.TAGS;

    private String type = Build.TYPE;

    private String user = Build.USER;

    private String appSign;//app签名sha1值

    private String baseBandVersion;//手机基带版本信息（21.290.03.01.031,21.290.03.01.031）

    private int battery;//电量（100）

    private String bluetooth;//蓝牙地址

    private int cameraNum;//摄像头数（2）

    private int cameraSiz=0;//摄像头像素（12979200） 支持分辨率多个，且需要打开摄像头，可不取

    private long diskSpace;//手机存储大小,单位bite

    private long diskFreeSpace;//手机剩余存储大小,单位bite

    private long totalMemory;//手机内存大小,单位bite

    private long freeMemory;//手机剩余内存大小,单位bite

    private boolean isNetworkingRoaming = false;//手机是否处于漫游状态（false）

    private boolean isDebug;//是否是调试模式（false）

    private boolean isProxy = false;//手机是否设置代理

    private boolean isRoot;//是否root（false）

    private boolean isSimulator;//是否是模拟器（false）

    private String kernelVersion;//android linux内核版本（3.10.90-g033208c）

    private String macAddress;//mac地址

    private long upTime;//手机最后一次重启到现在的时长（毫秒）

    private String imsi = "";//国际移动用户识别码（需要权限，可以不传)

    private String simCountryIso = "";//SIM卡提供商的国家代码 （需要权限，可以不传)

    private String simOperator = "";//SIM卡提供的移动国家码和移动网络码（需要权限，可以不传)

    private String simOperatorName = "";//服务商名称（移动）（需要权限，可以不传)

    private String networkCountryIso = "";//ISO标准的国家码，即国际长途区号（需要权限，可以不传)

    private String networkOperator = "";//MCC+MNC代码 (SIM卡运营商国家代码和运营商网络代码)（需要权限，可以不传)

    private String networkType = "";//获取网络类型（wifi 、 mobile or unknow)（需要权限，可以不传)

    private String wifiBssid = "";//BSSID （9c:3d:cf:3d:f1:48）可理解成热点的mac地址，但实际有所不同（需要权限，可以不传)

    private String wifiSsid = "";//SSID: 描述wifi热点的名称，就是大家搜索到的直接名称，如ChinaNet（需要权限，可以不传)

    private int wifiRssi = 0;//RSSI 描述wifi信号强弱的值，官方叫做level（-54）（需要权限，可以不传)


    public void setLocal(Locale locale) {
        country = locale.getCountry();
        language = locale.getLanguage();
        displayCountry = locale.getDisplayCountry();
        displayLanguage = locale.getDisplayLanguage();
        displayName = locale.getDisplayName();
    }


    public void setTimeZone(TimeZone timeZone) {
        city = timeZone.getID();
        timeZoneShort = timeZone.getDisplayName(false, TimeZone.SHORT);
        timeZoneLong = timeZone.getDisplayName(false, TimeZone.LONG);
    }


    public int getScreenWidth() {
        return screenWidth;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public int getScreenHeight() {
        return screenHeight;
    }

    public void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
    }

    public String getAndroidId() {
        return androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDisplayCountry() {
        return displayCountry;
    }

    public void setDisplayCountry(String displayCountry) {
        this.displayCountry = displayCountry;
    }

    public String getDisplayLanguage() {
        return displayLanguage;
    }

    public void setDisplayLanguage(String displayLanguage) {
        this.displayLanguage = displayLanguage;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getTimeZoneShort() {
        return timeZoneShort;
    }

    public void setTimeZoneShort(String timeZoneShort) {
        this.timeZoneShort = timeZoneShort;
    }

    public String getTimeZoneLong() {
        return timeZoneLong;
    }

    public void setTimeZoneLong(String timeZoneLong) {
        this.timeZoneLong = timeZoneLong;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getBoard() {
        return board;
    }

    public void setBoard(String board) {
        this.board = board;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModelNo() {
        return modelNo;
    }

    public void setModelNo(String modelNo) {
        this.modelNo = modelNo;
    }

    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getCpuAbi() {
        return cpuAbi;
    }

    public void setCpuAbi(String cpuAbi) {
        this.cpuAbi = cpuAbi;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getSdkVersion() {
        return sdkVersion;
    }

    public void setSdkVersion(int sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }


    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getHardware() {
        return hardware;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }


    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getAppSign() {
        return appSign;
    }

    public void setAppSign(String appSign) {
        this.appSign = appSign;
    }

    public String getBaseBandVersion() {
        return baseBandVersion;
    }

    public void setBaseBandVersion(String baseBandVersion) {
        this.baseBandVersion = baseBandVersion;
    }

    public int getBattery() {
        return battery;
    }

    public void setBattery(int battery) {
        this.battery = battery;
    }

    public String getBluetooth() {
        return bluetooth;
    }

    public void setBluetooth(String bluetooth) {
        this.bluetooth = bluetooth;
    }

    public int getCameraNum() {
        return cameraNum;
    }

    public void setCameraNum(int cameraNum) {
        this.cameraNum = cameraNum;
    }

    public long getDiskSpace() {
        return diskSpace;
    }

    public void setDiskSpace(long diskSpace) {
        this.diskSpace = diskSpace;
    }

    public long getDiskFreeSpace() {
        return diskFreeSpace;
    }

    public void setDiskFreeSpace(long diskFreeSpace) {
        this.diskFreeSpace = diskFreeSpace;
    }

    public String getFingerPrint() {
        return fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public long getFreeMemory() {
        return freeMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public String getImsi() {
        return imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public String getSimCountryIso() {
        return simCountryIso;
    }

    public void setSimCountryIso(String simCountryIso) {
        this.simCountryIso = simCountryIso;
    }

    public String getSimOperator() {
        return simOperator;
    }

    public void setSimOperator(String simOperator) {
        this.simOperator = simOperator;
    }

    public String getSimOperatorName() {
        return simOperatorName;
    }

    public void setSimOperatorName(String simOperatorName) {
        this.simOperatorName = simOperatorName;
    }

    public boolean isDebug() {
        return isDebug;
    }

    public void setDebug(boolean debug) {
        isDebug = debug;
    }

    public boolean isNetworkingRoaming() {
        return isNetworkingRoaming;
    }

    public void setNetworkingRoaming(boolean networkingRoaming) {
        isNetworkingRoaming = networkingRoaming;
    }

    public boolean isProxy() {
        return isProxy;
    }

    public void setProxy(boolean proxy) {
        isProxy = proxy;
    }

    public boolean isRoot() {
        return isRoot;
    }

    public void setRoot(boolean root) {
        isRoot = root;
    }

    public boolean isSimulator() {
        return isSimulator;
    }

    public void setSimulator(boolean simulator) {
        isSimulator = simulator;
    }

    public String getKernelVersion() {
        return kernelVersion;
    }

    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public String getMacAddress() {
        return macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getNetworkCountryIso() {
        return networkCountryIso;
    }

    public void setNetworkCountryIso(String networkCountryIso) {
        this.networkCountryIso = networkCountryIso;
    }

    public String getNetworkOperator() {
        return networkOperator;
    }

    public void setNetworkOperator(String networkOperator) {
        this.networkOperator = networkOperator;
    }

    public String getNetworkType() {
        return networkType;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public String getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public long getUpTime() {
        return upTime;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public String getWifiBssid() {
        return wifiBssid;
    }

    public void setWifiBssid(String wifiBssid) {
        this.wifiBssid = wifiBssid;
    }

    public String getWifiSsid() {
        return wifiSsid;
    }

    public void setWifiSsid(String wifiSsid) {
        this.wifiSsid = wifiSsid;
    }

    public int getWifiRssi() {
        return wifiRssi;
    }

    public void setWifiRssi(int wifiRssi) {
        this.wifiRssi = wifiRssi;
    }
}

