package com.common.activity;

import android.content.Intent;
import android.support.v4.app.FragmentActivity;


import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

import tech.starwin.R;
import com.common.base.BaseActivity;
import com.common.fragment.RegionFragment;
import tech.starwin.utils.context_utils.EasyActivityResult;
import tech.starwin.utils.context_utils.FragmentLauncher;
import tech.starwin.utils.event_bus.EventMessage;

/**
 * Created by SiKang on 2018/9/27.
 */
public class RegionActivity extends BaseActivity {
    public static final int CHANGE_REGION_TITLE = -1001;

    @Override
    public int bindLayout() {
        return R.layout.activity_region;
    }

    @Override
    public FragmentLauncher getFragmentLauncher() {
        return new FragmentLauncher(this, R.id.activity_area_frgmentLayout);
    }

    @Override
    public void initView() {
        EventBus.getDefault().register(this);
        startFragment(new RegionFragment(), false);
    }

    public static void startForResult(FragmentActivity activity, int requestCode, EasyActivityResult.OnResultListener listener) {
        Intent intent = new Intent(activity, RegionActivity.class);
        new EasyActivityResult(activity).startForResult(intent, requestCode, listener);
    }


    @Subscribe
    public void onEvent(EventMessage msg) {
        if (msg.what == CHANGE_REGION_TITLE) {
            setTopBarTitle(msg.msg);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister(this);
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }

}
