#!/usr/bin/env bash
cd ../../../
. gradle.properties

alias="keystore${RANDOM}"
certificate="../jks/${alias}.keystore"
certificatePassword=${alias}
storePassword=${alias}

LC_CTYPE=C && LANG=C && sed -i "" "s#^signing_keyAlias=.*#signing_keyAlias=${alias}#g"  gradle.properties
LC_CTYPE=C && LANG=C && sed -i "" "s#^signing_certificate=.*#signing_certificate=${certificate}#g"  gradle.properties
LC_CTYPE=C && LANG=C && sed -i "" "s#^signging_certificatePassword=.*#signging_certificatePassword=${certificatePassword}#g"  gradle.properties
LC_CTYPE=C && LANG=C && sed -i "" "s#^signging_storePassword=.*#signging_storePassword=${storePassword}#g"  gradle.properties


rm -rf jks/*
echo "ready to create new kestore ${alias}"
keytool -genkey -alias "${alias}" -keypass "${alias}" -storepass "${alias}" -dname "CN=Unknown, OU=Unknown, O=Unknown, L=Unknown, ST=Unknown, C=Unknown" -keyalg RSA -validity 20000 -keystore jks/"${alias}".keystore