package tech.starwin.utils.tracker;

/**
 * Created by SiKang on 2019/6/14.
 */
public final class TrackEvent {
    /**
     * Api 参数
     */
    private static String type_system = "system";
    private static String action_api = "api";

    private static String type_user = "user";
    private static String actoin_click = "click";
    private static String action_screen = "hold";


    public interface Event {
        String type();

        String action();

        String value();
    }


    public enum Screen implements Event {
        /**
         * 进入隐私协议页面
         */
        AGREEMENT(type_user, action_screen, "agreement"),

        /**
         * 进入主页
         */
        HOME(type_user, action_screen, "home"),

        /**
         * 进入假界面
         */
        FAKE_HOME(type_user, action_screen, "fake_home"),

        /**
         * 进入FB登录页面
         */
        ACCOUNT_KIT(type_user, action_screen, "account_kit"),

        /**
         * 进入SMS登录页面
         */
        SMS_LOGIN(type_user, action_screen, "sms_login");




        public String type;
        public String action;
        public String event;

        Screen(String type, String action, String event) {
            this.type = type;
            this.action = action;
            this.event = event;
        }

        @Override
        public String type() {
            return type;
        }

        @Override
        public String action() {
            return action;
        }

        @Override
        public String value() {
            return event;
        }
    }

    public enum Click implements Event {
        /**
         * 点击允许权限 value: 权限名
         */
        ALLOW_PERMISSION(type_user, actoin_click, "allow_permission"),

        /**
         * 点击拒绝权限 value: 权限名
         */
        REFUSE_PERMISSION(type_user, actoin_click, "refuse_permission"),

        /**
         * 点击同意隐私协议
         */
        AGREE_PRIVACY(type_user, actoin_click, "agree_privacy"),

        /**
         * 切换到了KSP成员协议
         */
        VIEW_KSP_AGREEMENT(type_user, actoin_click, "view_ksp_agreement"),

        /**
         * 切换到了隐私协议
         */
        VIEW_NORMAL_AGREEMENT(type_user, actoin_click, "view_normal_agreement"),

        /**
         * 点击同意隐私协议,但由于没勾选协议无法提交
         */
        AGREE_FAILED(type_user, actoin_click, "agree_agreement_failed"),

        /**
         * 点击一个产品
         */
        PRODUCT_ITEM(type_user, actoin_click, "product_list"),

        /**
         * 点击登录（仅限SMS登录）
         */
        SMS_LOGIN(type_user, actoin_click, "sms_login"),

        /**
         * 点击获取验证码
         */
        SMS_CODE(type_user, actoin_click, "sms_code"),

        /**
         * 点击申请产品
         */
        LOAN_APPLY(type_user, actoin_click, "Loan_apply"),

        /**
         * 点击开始活体
         */
        START_LIVENESS(type_user, actoin_click, "start_liveness"),

        /**
         * 点击提交银行卡信息
         */
        SUBMIT_BANK_INFO(type_user, actoin_click, "submit_bank_info"),

        /**
         * 点击开始KTP拍照
         */
        KTP_SHOT(type_user, actoin_click, "ktp_shot"),

        /**
         * 点击提交KTP信息（无api调用）
         */
        SUBMIT_KTP_INFO(type_user, actoin_click, "submit_ktp_info"),

        /**
         * 点击提交个人信息
         */
        SUBMIT_PERSONAL_INFO(type_user, actoin_click, "submit_personal_info"),

        /**
         * 点击提交紧急联系人
         */
        SUBMIT_CONTACT_INFO(type_user, actoin_click, "submit_contact_info"),

        /**
         * 点击开始工作证件拍照
         */
        WORK_CARD_SHOT(type_user, actoin_click, "work_card_shot"),

        /**
         * 点击提交工作信息
         */
        SUBMIT_WORK_INFO(type_user, actoin_click, "submit_work_info"),

        /**
         * 点击三方认证 value: 具体认证项目
         */
        THIRD_PART_VERTIFY(type_user, actoin_click, "third_part_vertify"),

        /**
         * 点击一条贷款记录
         */
        LOAN_HISTORY_ITEM(type_user, actoin_click, "loan_history_item"),

        /**
         * 点击取消贷款
         */
        CANCEL_LOAN(type_user, actoin_click, "cancel_loan"),

        /**
         * 点击查看隐私协议
         */
        PRIVACY_AGREEMENT(type_user, actoin_click, "privacy_agreement");


        public String type;
        public String action;
        public String event;

        Click(String type, String action, String event) {
            this.type = type;
            this.action = action;
            this.event = event;
        }

        @Override
        public String type() {
            return type;
        }

        @Override
        public String action() {
            return action;
        }

        @Override
        public String value() {
            return event;
        }
    }


    public enum Api implements Event {

        /**
         * gw刷新成功
         * */
        GATEWAY_UPDATED(type_user, actoin_click, "gateway_updated"),

        /**
         * FB登录成功
         */
        ACCOUNT_KIT_LOGIN_SUCCESS(type_system, action_api, "accountkit_login_success"),

        /**
         * SMS登录成功
         */
        SMS_LOGIN_SUCCESS(type_system, action_api, "sms_login_success"),

        /**
         * 用户退出登录
         */
        LOG_OUT(type_system, action_api, "log_out"),

        /**
         * 活体识别成功
         */
        LIVENESS_SUCCESS(type_system, action_api, "liveness_success"),

        /**
         * 提交银行卡信息成功
         */
        BANK_INFO_SUBMITED(type_system, action_api, "bank_info_submited"),

        /**
         * 上传KTP照片成功
         */
        KTP_UPLOADED(type_system, action_api, "ktp_uploaded"),

        /**
         * 个人信息提交成功
         */
        PERSONAL_INFO_SUBMITED(type_system, action_api, "personal_info_submited"),

        /**
         * 紧急联系人提交成功
         */
        CONTACT_INFO_SUBMITED(type_system, action_api, "contact_info_submited"),

        /**
         * 工作照上传成功
         */
        WORK_CARD_UPLOADED(type_system, action_api, "work_card_uploaded"),

        /**
         * 工作信息提交成功
         */
        WORK_INFO_SUBMITED(type_system, action_api, "work_card_submited"),

        /**
         * 取消贷款成功
         */
        LOAN_CANNELED(type_system, action_api, "loan_canceled");


        public String type;
        public String action;
        public String event;

        Api(String type, String action, String event) {
            this.type = type;
            this.action = action;
            this.event = event;
        }

        @Override
        public String type() {
            return type;
        }

        @Override
        public String action() {
            return action;
        }

        @Override
        public String value() {
            return event;
        }
    }

}
