package tech.starwin.mvp.ui.fragment;

import android.os.Bundle;
import android.view.ViewGroup;

import tech.starwin.base.BaseFragment;
import tech.starwin.mvp.beans.LatestLoanAppBean;
import tech.starwin.utils.context_utils.ActivityJumper;

/**
 * Created by SiKang on 2018/10/16.
 */
public abstract class LoanInfoFragment extends BaseFragment {

    private LatestLoanAppBean loanAppInfo;

    @Override
    public final void initView(ViewGroup contentView) {
        if (getArguments() != null && getArguments().getParcelable("loanapp_info") != null) {
            loanAppInfo = (LatestLoanAppBean) getArguments().getParcelable("loanapp_info");
        }
        initLoanView(contentView, loanAppInfo);
    }

    protected abstract void initLoanView(ViewGroup contentView, LatestLoanAppBean loanAppInfo);

    public static Bundle createArguments(LatestLoanAppBean loanAppInfo) {
        return new ActivityJumper.Builder().put("loanapp_info", loanAppInfo).toBundle();
    }

}
