package com.common.fragment;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;

import com.qmuiteam.qmui.util.QMUIStatusBarHelper;

import tech.starwin.R;

import com.common.base.BaseFragment;

import tech.starwin.mvp.presenter.LoanPresenter;
import tech.starwin.mvp.presenter.UserPresenter;
import tech.starwin.utils.context_utils.ActivityJumper;

import com.common.widget.TopBar;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

/**
 * Created by SiKang on 2018/11/20.
 */
public class RepaymentH5Fragment extends BaseFragment {
    SmartRefreshLayout refreshLayout;

    @Override
    public boolean useTopBar() {
        return true;
    }

    @Override
    protected void initTopBar(TopBar topBar) {
        topBar.setStatusBarHeight(QMUIStatusBarHelper.getStatusbarHeight(getActivity()));
        topBar.toolBar().setBackgroundColor(getResources().getColor(R.color.translateColor));
        topBar.toolBar().addLeftBackImageButton().setVisibility(View.INVISIBLE);
        topBar.toolBar().setTitle(R.string.repayment_text);
    }

    WebView webView;

    public static Bundle createArguments(String repayUrl) {
        return new ActivityJumper.Builder()
                .put("url", repayUrl)
                .toBundle();
    }

    @Override
    public int bindLayout() {
        return R.layout.activity_web;
    }

    @Override
    public void initView(ViewGroup contentView) {

        refreshLayout = contentView.findViewById(R.id.activity_web_refresh);
        webView = (WebView) findViewById(R.id.activity_web_wv);

        WebSettings setting = webView.getSettings();
        setting.setJavaScriptEnabled(true);//设置webview支持javascript脚本
        setting.setCacheMode(WebSettings.LOAD_NO_CACHE);//不加载缓存

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    refreshLayout.finishRefresh();
                }
            }
        });


        refreshLayout.setEnableLoadMore(false);
        refreshLayout.setOnRefreshListener(refreshLayout -> {
            WebStorage.getInstance().deleteAllData();//主动清除数据
            webView.loadUrl(getArguments().getString("url"));
        });



    }

    @Override
    public void onStart() {
        super.onStart();
        refreshLayout.autoRefresh();
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
