package tech.starwin.network;


import com.common.bean.GatewayInfoBean;

import java.util.Arrays;
import java.util.List;

import tech.starwin.BuildConfig;
import tech.starwin.LibConfig;
import tech.starwin.utils.LoginManager;
import tech.starwin.utils.PreferencesManager;

/**
 * Created by SiKang on 2018/9/28.
 */
public class Gateway {
    private static GatewayInfoBean gatewayInfo;

    public static void init(GatewayInfoBean info) {
        gatewayInfo = info;
        if (gatewayInfo == null) {
            gatewayInfo = new GatewayInfoBean();
            gatewayInfo.gateway = Arrays.asList(LibConfig.GATEWAY_HOST_G0,
                    LibConfig.GATEWAY_HOST_G1);
            gatewayInfo.rest = Arrays.asList(LibConfig.API_BASE_URL);
            gatewayInfo.privacy = Arrays.asList(LibConfig.AGREEMENT_URL);
            gatewayInfo.repay = Arrays.asList(LibConfig.REPAYMENT_H5);
            gatewayInfo.admin = Arrays.asList(LibConfig.ADMIN_HOST);
            gatewayInfo.harvester = Arrays.asList(LibConfig.HARVESTER_IP + ":" + LibConfig.HARVESTER_PORT);
        }
    }

    /**
     * 更新gateway
     */
    public static void setGatewayInfoBean(GatewayInfoBean info) {
        gatewayInfo.notifyWith(info);
        PreferencesManager.get().saveGatewayInfo(info);
    }

    public static List<String> getGatewayUrl() {
        return gatewayInfo.gateway;
    }

    /**
     * 注册协议和隐私政策
     */
    public static String getAgreementPolicyUrl() {
        String permissions = BuildConfig.NEED_CONTACT ? "1235" : "235";
        return gatewayInfo.privacy.get(0) + "?name=" +
                LibConfig.APP_NAME.replace(" ", "%20") +
                "&list=" + permissions;
    }


    /**
     * KSP成员协议
     */
    public static String getKSPUrl() {
        return getAgreementPolicyUrl().replace(".html", "Ksp.html");
    }

    /**
     * 上传地址
     */
    public static String getHarvesterUrl() {
        return gatewayInfo.harvester.get(0);
    }


    public static String getAdminUrl() {
        return gatewayInfo.admin.get(0);
    }

    /**
     * 贷款担保协议
     */
    public static String getLoanAgreement(String loanId) {
        StringBuilder builder = new StringBuilder();
        builder.append(getAdminUrl())
                .append("/contract/contract-template-detail")
                .append("?loanId=" + loanId)
                .append("&token=" + LoginManager.get().getToken());
        String url = builder.toString();
        return url;
    }


    /**
     * 还款页面
     */
    public static String getRepayUrl() {
        if (gatewayInfo.repay == null || gatewayInfo.repay.size() == 0) {
            return "";
        }
        return gatewayInfo.repay.get(0) + "token=" + LoginManager.get().getToken();
    }

    public static String getRestUrl() {
        return gatewayInfo.rest.get(0);
    }

}
