#!/usr/bin/env python3
import json
import string
import random
import glob, os
import sys

class SdkManager:
    def __disable_code(self, path, sdk):
    # print("processing content: %s..." % path)
        with open(path, "r", encoding="utf-8") as f:
            lines = f.readlines()

        with open(path, "w", encoding="utf-8") as f_w:
            is_sdk_code = False
            for line in lines:
                if "//SDK-"+sdk+"-END" in line or "<!--SDK-"+sdk+"-END-->" in line:
                    is_sdk_code = False

                java_mark ="//SDK-" + sdk + "-CODE ->";
                xml_mark ="<!--SDK-" + sdk + "-CODE//";
                if (path.endswith(".java") or path.endswith(".gradle")) and is_sdk_code and java_mark not in line:
                    line = java_mark + line

                if path.endswith(".xml") and is_sdk_code and xml_mark not in line:
                    line = xml_mark + line.replace("\n","//-->\n")

                if "//SDK-"+sdk+"-START" in line or "<!--SDK-"+sdk+"-START-->" in line:
                    is_sdk_code = True

                f_w.write(line)
        return

    def __enable_code(self, path, sdk):
        # print("processing content: %s..." % path)
        code_mark = "//SDK-" + sdk + "-CODE ->"
        xml_mark = "<!--SDK-" + sdk + "-CODE//"
        with open(path, "r", encoding="utf-8") as f:
            lines = f.readlines()

        with open(path, "w", encoding="utf-8") as f_w:
            for line in lines:
                if code_mark in line:
                    line = line.replace(code_mark,"")
                if xml_mark in line:
                    line = line.replace(xml_mark,"").replace("//-->","")
                f_w.write(line)
        return

    def __process_files(self, path, enable, sdk_mark):
        if not os.path.isdir(path):
            if enable:
                self.__enable_code(path, sdk_mark)
            else:
                self.__disable_code(path, sdk_mark)
        else:
            for root, dirs, files in os.walk(path):
                directory = os.path.join(os.getcwd(), root)
                for file in files:
                    if file.endswith(".java") or file.endswith("AndroidManifest.xml") or file.endswith(".gradle"):
                        # get the path of the java file
                        path = os.path.join(directory, file)
                        if enable:
                            self.__enable_code(path, sdk_mark)
                        else:
                            self.__disable_code(path, sdk_mark)

    
    def start_process(self, config, enable, sdk_mark):
        #混淆build.gradle
        self.__process_files("%s/app/build.gradle"% config['root'], enable, sdk_mark)
        self.__process_files("%s/lib_base/build.gradle"% config['root'], enable, sdk_mark)

        #混淆代码
        self.__process_files("%s/app/src/main"% config['root'], enable, sdk_mark)
        self.__process_files("%s/lib_base/src/main"% config['root'], enable, sdk_mark)

        print("done")


    def sdk_manage(self, config):
        print(" ")
        print("1、启用SDK")
        print("2、禁用SDK")
        command = int(input("请输入指令编号："))

        print(" ")
        print("占位的标记：ADVANCE、YITU、MOTION 等")
        sdk = str(input("要操作的SDK："))

        if command == 1:
            self.start_process(config, True, sdk)
        else:
            self.start_process(config, False, sdk)



