package tech.starwin.utils.ui_utils;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import com.tbruyelle.rxpermissions2.Permission;

import tech.starwin.R;
import tech.starwin.base.RecyclerViewHolder;
import com.common.bean.LatestLoanAppBean;
import com.common.bean.UpdateBean;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.context_utils.PermissionsHelper;

/**
 * Created by SiKang on 2018/11/20.
 * 业务相关的Dialog管理
 */
public class DialogManager {
    /**
     * 显示贷款成功Dialog
     */
    public static void showLoanSuccessDialog(Context context, @DrawableRes int imageId) {
        PreferencesManager.get().setLoanRsultNotifyStatus(true);
        DialogFactory.createCustomDialog(context, R.layout.dialog_loan_success, (dialog, viewHolder) -> {
            viewHolder.getImageView(R.id.iv_closed_header).setImageResource(imageId);
            viewHolder.getButton(R.id.btn_dialog_current_oko).setOnClickListener(v -> dialog.dismiss());
        }).show();
    }

    /**
     * 显示贷款关闭Dialog
     */
    public static void showLoanClosedDialog(Context context, @DrawableRes int imageId, LatestLoanAppBean latestLoanAppBean) {
        PreferencesManager.get().setLoanRsultNotifyStatus(true);
        DialogFactory.createCustomDialog(context, R.layout.dialog_loan_closed, (dialog, viewHolder) -> {
            viewHolder.getImageView(R.id.iv_closed_header).setImageResource(imageId);
            if (latestLoanAppBean != null && latestLoanAppBean.getComments() != null) {
                String[] closedReasons = latestLoanAppBean.getComments().split(",");
                StringBuilder closedReasonsStr = new StringBuilder();
                for (int j = 1; j <= closedReasons.length; j++) {
                    closedReasonsStr.append(j).append(". ").append(closedReasons[j - 1]).append
                            ("\n");
                }
                viewHolder.getTextView(R.id.id_textview_closed_dialog_content).setText(closedReasonsStr.toString());
            }
            viewHolder.getButton(R.id.id_button_goto_modify).setOnClickListener(v -> dialog.dismiss());
        }).show();
    }


    /**
     * 显示贷款失败Dialog
     */
    public static void showLoanFailedDialog(Context context, @DrawableRes int imageId) {
        PreferencesManager.get().setLoanRsultNotifyStatus(true);
        DialogFactory.createCustomDialog(context, R.layout.dialog_loan_failed, (dialog, viewHolder) -> {
            viewHolder.getImageView(R.id.iv_closed_header).setImageResource(imageId);
            viewHolder.getButton(R.id.btn_result_failed).setOnClickListener(v -> dialog.dismiss());
        }).show();
    }


    /**
     * 更新弹窗
     */
    public static void showUpdateDialog(Context context, @DrawableRes int imgId, UpdateBean updateBean, View.OnClickListener listener) {
        Dialog dialog = DialogFactory.createCustomDialog(context, R.layout.dialog_update, (dialog1, viewHolder) -> {
            viewHolder.getImageView(R.id.tv_dialog_update_title).setImageResource(imgId);
            viewHolder.getButton(R.id.btn_dialog_update_download).setOnClickListener(listener);
            if (updateBean != null && updateBean.getReleaseNotes() != null && updateBean.getReleaseNotes().size() > 0) {
                viewHolder.getTextView((R.id.tv_update_notes)).setText(updateBean.getReleaseNotesStr());
            }
        });
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(false);
        dialog.show();

    }





}
