package tech.starwin.mvp.api;


import io.reactivex.Observable;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Multipart;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Query;

import com.common.bean.BasicAck;
import com.common.bean.OcrResultBean;
import com.common.bean.RecordFilesResponse;

/**
 * Created by SiKang on 2018/9/14.
 * 涉及上传的API
 */
public interface UploadApi {

    /**
     * 上传照片
     *
     * @param fileType 照片类型   KTP_PHOTO：身份证;
     *                 EMPLOYMENT_PHOTO：工作证件;
     *                 CONTRACT_VIDEO：合同;
     */
    @Multipart
    @PUT("record/files")
    Observable<ResponseBody> uploadPhoto(
            @Part MultipartBody.Part photoFile,
            @Query("fileType") String fileType,
            @Header("X-AUTH-TOKEN") String token
    );

    @FormUrlEncoded
    @PUT("record/firebase_token")
    Observable<ResponseBody> uploadFirebaseToken(@Field("firebase_token") String token);


    @Multipart
    @PUT("loanapp/contract/video")
    Call<ResponseBody> uploadVideo(@Part MultipartBody.Part videoFile,
                                   @Query("loanAppId") String loanAppId,
                                   @Query("fileType") String fileType,
                                   @Header("X-AUTH-TOKEN") String token);

    @GET("record/files")
    Call<RecordFilesResponse> recordFiles(@Header("X-AUTH-TOKEN") String token);

    @Multipart
    /*@PUT("/loanapp/verify/face") face++*/
    @PUT("/loanapp/verify/yitu")
    Call<BasicAck> faceVerify(@Query("loanType") String loanType,
                              @Query("amount") double amount,
                              @Query("period") int period,
                              @Query("periodUnit") String periodUnit,
                              @Part MultipartBody.Part imageBest,
                              @Part MultipartBody.Part imageEnv,
                              @Part MultipartBody.Part delta,
                              @Query("imei") String imei,
                              @Query("productId") long productId,
                              @Query("thirdpartyDataFlag")Boolean thirdpartyDataFlag,
                              @Header("X-AUTH-TOKEN") String token);


    /**
     * 身份证ocr识别
     */
    @Multipart
    @PUT("/record/ocr")
    Observable<OcrResultBean> identityOcr(@Part MultipartBody.Part part, @Header("X-AUTH-TOKEN") String token);



}