import random


class ClassBuilder:
    __used_names = []
    __variables = []
    __functions = []
    __name = ""
    def __gen_rand_str(self):
        result = ""
        while len(result) == 0 or result in self.__used_names:
            random_str = ''.join(random.sample(
                "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(6, 10)))
            result = "%s%d" % (random_str, random.randint(1, 100))
        self.__used_names.append(result)
        return result

    # 生成变量
    def __generate_variable(self):
        var_scope = ["public", "private", "protected"]
        var_types = ["String", "int", "double", "float"]
        var_count = random.randint(3, 15)
        for i in range(0, var_count):
            code = "%s %s %s = " % (
                var_scope[random.randint(0, 2)],
                var_types[random.randint(0, 3)],
                self.__gen_rand_str()
            )
            if " String " in code:
                code += "\"%s\"" % self.__gen_rand_str()
            else:
                code += "%d" % random.randint(1, 1000)
            code += ";"
            self.__variables.append(code)

    # 生成方法
    def __generate_function(self, model_path):
        func_scope = ["public", "private", "protected"]
        return_type = ["String", "int", "double", "float"]

        fun_content = ""
        with open(model_path, "r", encoding="utf-8") as fin:
            fun_content = fin.read()

        re_type = return_type[random.randint(0, 3)]
        fun_content = fun_content\
            .replace("${func_scope}", func_scope[random.randint(0, 2)])\
            .replace("${return_type}", re_type)\
            .replace("${func_name}", self.__gen_rand_str())

        # 方法参数
        param_names = []
        params_code = ""
        for i in range(0, random.randint(1, 5)):
            parans_name = self.__gen_rand_str()
            code = "%s %s" % (
                return_type[random.randint(0, 3)],
                parans_name
            )
            params_code += code + ", "
            param_names.append(parans_name)

        params_code = ("%s*" % params_code).replace(", *", "")
        fun_content = fun_content.replace("${params}", params_code)

        # 随机引用全局变量
        for var_code in self.__variables:
            if random.randint(0, 2) % 2 == 0:
                param_names.append(var_code.split(" ")[2])
        return_value = ""
        for name in param_names:
            return_value += name + "+"

        # 转string
        return_value += "\"\""

        if re_type in "int":
            return_value = "(%s).length()" % return_value
        elif re_type in "float":
            return_value = "Float.valueOf((%s).length())" % return_value
        elif re_type in "double":
            return_value = "Double.valueOf((%s).length())" % return_value

        return_value = "return %s;" % return_value

        log_code = ""
        for i in range(0, random.randint(0, 5)):
            log_code += "Log.%s(\"%s\",\"%s\");\n" % (
                ''.join(random.sample("idew", random.randint(1, 1))),
                self.__name,
                ''.join(random.sample("ABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(5, 15)))
            )

        fun_content = fun_content.replace(
            "${func_content}", log_code + return_value)
        self.__functions.append(fun_content)

        if len(self.__functions) < random.randint(3, 15):
            self.__generate_function(model_path)

    # 生成类
    def __generate_class(self, model_path):
        class_content = ""
        with open(model_path, "r", encoding="utf-8") as fin:
            class_content = fin.read()
        variables = ""
        for var_code in self.__variables:
            variables += "%s\n" % var_code

        functions = ""
        for func_code in self.__functions:
            functions += "%s\n\n" % func_code

        return class_content.replace("${variable}", variables)\
            .replace("${function}", functions)
        

    def new_class(self,class_name,pkg_name):
        self.__name = class_name
        self.__generate_variable()
        self.__generate_function("tools/garbel/model/function_model.java")
        class_content = self.__generate_class("tools/garbel/model/activity_model.java")
        class_content = class_content.replace("${class_name}",class_name)\
            .replace("${pkg_name}",pkg_name)
        
        return class_content
        # for var_code in self.__variables:
        #     print(var_code)
        # for func_code in self.__functions:
        #     print(func_code)


if __name__ == "__main__":
    ClassBuilder().new_class("test","test")
