# -*-coding:utf-8-*-
import random
import re
import os


class JavaGarble:
    __used_names = []
    __variables = []
    __functions = []
    __logic_model = ""
    __config = {}

    def __gen_rand_str(self):
        result = ""
        while len(result) == 0 or result in self.__used_names:
            result = ''.join(random.sample(
                "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(2, 10)))
        self.__used_names.append(result)
        return result

    # 生成变量

    def __generate_variable(self):
        var_scope = ["public", "private", "protected"]
        var_types = ["String", "int", "double", "float"]
        var_count = random.randint(
            random.randint(3, 10), random.randint(20, 30))
        for i in range(0, var_count):
            code = "%s %s %s = " % (
                var_scope[random.randint(0, 2)],
                var_types[random.randint(0, 3)],
                self.__gen_rand_str()
            )
            if " String " in code:
                code += "\"%s\"" % self.__gen_rand_str()
            else:
                code += "%d" % random.randint(1, 1000)
            code += ";"
            self.__variables.append(code)

    # 生成方法
    def __generate_function(self, model_path):
        func_scope = ["public", "private", "protected"]
        return_type = ["String", "int", "double", "float"]

        fun_content = ""
        with open(model_path, "r", encoding="utf-8") as fin:
            fun_content = fin.read()

        re_type = return_type[random.randint(0, 3)]
        fun_content = fun_content\
            .replace("${func_scope}", func_scope[random.randint(0, 2)])\
            .replace("${return_type}", re_type)\
            .replace("${func_name}", self.__gen_rand_str())

        # 方法参数
        param_names = []
        params_code = ""
        for i in range(0, random.randint(1, 5)):
            parans_name = self.__gen_rand_str()
            code = "%s %s" % (
                return_type[random.randint(0, 3)],
                parans_name
            )
            params_code += code + ", "
            param_names.append(parans_name)

        params_code = ("%s*" % params_code).replace(", *", "")
        fun_content = fun_content.replace("${params}", params_code)

        # 随机引用全局变量
        for var_code in self.__variables:
            if random.randint(0, 2) % 2 == 0:
                param_names.append(var_code.split(" ")[2])
        return_value = ""
        for name in param_names:
            return_value += name + "+"

        # 转string
        return_value += "\"\""

        if re_type in "int":
            return_value = "(%s).length()" % return_value
        elif re_type in "float":
            return_value = "Float.valueOf((%s).length())" % return_value
        elif re_type in "double":
            return_value = "Double.valueOf((%s).length())" % return_value

        return_value = "return %s;" % return_value

        log_code = ""
        for i in range(0, random.randint(0, 5)):
            log_code += "android.util.Log.%s(\"%s\",\"%s\");\n" % (
                ''.join(random.sample("idew", random.randint(1, 1))),
                ''.join(random.sample(
                    "ABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(3, 10))),
                ''.join(random.sample(
                    "ABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(5, 15)))
            )

        fun_content = fun_content.replace(
            "${func_content}", log_code + return_value)
        self.__functions.append(fun_content)

        if len(self.__functions) < random.randint(3, 10):
            self.__generate_function(model_path)

    # 插入代码
    def __insert_code(self):
        codes = self.__logic_model.split("//sep")
        code = codes[random.randint(0, len(codes)-1)]
        code = code.replace("${string}", self.__gen_rand_str())\
            .replace("${name}", self.__gen_rand_str())\
            .replace("${number}", str(random.randint(1, 10000)))

        vars_size = len(self.__variables)-1
        items = self.__variables[random.randint(0, vars_size)].split(" ")
        if "String" in items[1]:
            condition = "%s.length()%s%s" % (
                items[2], random.sample("><", 1), items[4])
        else:
            condition = "%s%s%s" % (items[2], random.sample("><", 1), items[4])
        code = code.replace("${condition}", condition)

        content = ""
        for i in range(0, random.randint(0, vars_size)):
            var = self.__variables[random.randint(0, vars_size)]
            content += "%s + " % var.split(" ")[2]
        content = "System.out.println((%s\"\").length());" % content

        code = code.replace("${content}", content)
        return code

    def __garble_java_file(self, file):
        self.__used_names = []
        self.__variables = []
        self.__functions = []
        with open(file, "r", encoding="utf-8") as fin:
            lines = fin.readlines()

        # 生成全局变量
        self.__generate_variable()
        # 生成方法
        self.__generate_function("tools/garble/model/function_model.java")

        ignore = False
        # 花括号
        curly_braces = 0
        with open(file, "w+", encoding="utf-8") as fout:
            for line in lines:
                # interface 不混淆
                if "interface" in line and "{\n" in line or ignore:
                    ignore = True
                    fout.write(line)
                    continue

                if (line.startswith("class ") or " class " in line) and "{\n" in line:
                    # 插入全局变量
                    for var in self.__variables:
                        line += "%s\n" % var
                    # 插入方法
                    for fun in self.__functions:
                        line += "%s\n" % fun

               

                # 定位1个缩进开头的类方法
                if (line.startswith("    ") and not line.startswith("     ")) and ("){\n" in line or ") {\n" in line):
                    curly_braces = line.count("{")
                    curly_braces -= line.count("}")
                
                if curly_braces > 0:
                    curly_braces += line.count("{")
                    curly_braces -= line.count("}")

                # 一个花括号表示在方法的直接作用域内
                if curly_braces == 1:
                    if "return" in line:
                        curly_braces = -10000
                        continue

                    if ";\n" in line:
                        line += "\n%s" % self.__insert_code()

                fout.write(line)

    def java_garble(self, config):
        self.__config = config
        with open("tools/garble/model/logic_model.java", "r", encoding="utf-8") as fin:
            self.__logic_model = fin.read()

        for main_dir in config['lib_main']:
            for root, dirs, files in os.walk("%s/%s" % (config["root"], main_dir)):
                for file in files:
                    if file.endswith(".java"):
                        self.__garble_java_file(os.path.join(root, file))
