package tech.starwin.common.impl;

import android.view.View;

/**
 * Created by SiKang on 2018/9/18.
 */
public abstract class OnNoShakeClickListener implements View.OnClickListener {
    public abstract void onNoShakeClick(View view);

    public int lockTime = 1500;

    public OnNoShakeClickListener(int milliSencons) {
        this.lockTime = milliSencons;
    }

    public OnNoShakeClickListener() {
    }

    @Override
    public void onClick(final View view) {
        view.setClickable(false);
        view.postDelayed(new Runnable() {
            @Override
            public void run() {
                view.setClickable(true);
            }
        }, lockTime);
        onNoShakeClick(view);
    }
}
