package tech.starwin.mvp.api;

import io.reactivex.Observable;
import retrofit2.http.GET;
import retrofit2.http.Header;
import tech.starwin.mvp.beans.LatestLoanAppBean;
import tech.starwin.mvp.beans.LoanRange;
import tech.starwin.mvp.beans.ProgressBean;
import tech.starwin.mvp.beans.ResponseErrorBody;

/**
 * Created by SiKang on 2018/9/20.
 */
public interface LoanApi {
    /**
     * 获取贷款额度、期限 范围
     */
    @GET("loanapp/range")
    Observable<LoanRange> getLoanRange();

    /**
     * 验证贷款资格
     */
    @GET("loanapp/qualification")
    Observable<ResponseErrorBody> isQualification(@Header("X-AUTH-TOKEN") String token);

    /**
     * 贷款进度
     */
    @GET("record/progress")
    Observable<ProgressBean> getLoanProgress(@Header("X-AUTH-TOKEN") String token);


    /**
     * 获取最新的贷款申请信息
     */
    @GET("loanapp/latest/v2")
    Observable<LatestLoanAppBean> getLatestLoanApp(@Header("X-AUTH-TOKEN") String token);

}
