package tech.starwin.mvp.presenter;

import android.support.annotation.Nullable;

import com.google.gson.Gson;


import java.io.File;
import java.util.List;

import okhttp3.MultipartBody;
import tech.starwin.base.BasePresenter;
import tech.starwin.common.impl.HttpObserver;
import tech.starwin.mvp.api.UploadApi;
import tech.starwin.mvp.beans.OcrResultBean;
import tech.starwin.utils.LoginManager;
import tech.starwin.utils.MultipartBodyMaker;

/**
 * Created by SiKang on 2018/9/25.
 */
public class UploadPresenter extends BasePresenter<UploadApi> {

    public UploadPresenter() {
        super(UploadApi.class);
    }

    /**
     * 身份证ocr识别
     */
    public void identityOcr(final String action, @Nullable File file) {
        List<MultipartBody.Part> parts = new MultipartBodyMaker.Builder()
                .addDataPart("file", file)
                .build().makeParts();

        handleRequest(apiService.identityOcr(parts, LoginManager.get().getToken()), new HttpObserver<OcrResultBean>() {
            @Override
            public void onStart() {
                view.onHttpStart(action, true);
            }

            @Override
            public void onSuccess(OcrResultBean data) {
                OcrResultBean.KTP ktp = new Gson().fromJson(data.getData(), OcrResultBean.KTP.class);
                if (ktp.getResult().equals("PASS"))
                    view.onHttpSuccess(action, ktp);
                else
                    view.onHttpError(action, ktp.getMessage());
            }

            @Override
            public void onError(int code, String msg) {
                view.onHttpError(action, msg);
            }

            @Override
            public void onFinish() {
                view.onHttpFinish(action);
            }
        });
    }
}
