package tech.starwin.utils;

import android.app.Activity;
import android.content.SharedPreferences;
import android.text.TextUtils;

import java.util.Map;

import tech.starwin.base.LibConfig;
import tech.starwin.mvp.beans.GatewayInfoBean;
import tech.starwin.mvp.beans.PersonalInfo;
import tech.starwin.mvp.beans.TokenInfoBean;
import tech.starwin.mvp.beans.UserBean;

/**
 * Created by SiKang on 2018/9/18.
 */
public class PreferencesManager {
    private static final String PREFERENCES_FILE_NAME = "base_info";
    //单例
    private static PreferencesManager preferencesManager;
    // 获取SharedPreferences对象
    private SharedPreferences mSharedPreferences;
    // 获取Editor对象
    private SharedPreferences.Editor mEditor;


    private PreferencesManager() {
        mSharedPreferences = LibConfig.getContext().getSharedPreferences(PREFERENCES_FILE_NAME, Activity.MODE_PRIVATE);
        mEditor = mSharedPreferences.edit();
    }

    public static PreferencesManager get() {
        if (preferencesManager == null) {
            synchronized (PreferencesManager.class) {
                if (preferencesManager == null) {
                    preferencesManager = new PreferencesManager();
                }
            }
        }
        return preferencesManager;
    }

    /**
     * 保存登录信息
     */
    public void saveTokenInfo(TokenInfoBean tokenInfoBean) {
        saveData("token_info", GeneralUtils.fromBean(tokenInfoBean));
    }

    /**
     * 获取登录信息
     */
    public TokenInfoBean getTokenInfo() {
        String tokenStr = getString("token_info", "");
        return TextUtils.isEmpty(tokenStr) ? null : (TokenInfoBean) GeneralUtils.toBean(tokenStr);
    }

    /**
     * 保存用户登录信息
     */
    public void saveUserInfo(UserBean userBean) {
        saveData("user_info", GeneralUtils.fromBean(userBean));
    }

    /**
     * 获取用户登录信息
     */
    public UserBean getUserInfo() {
        String userStr = getString("user_info", "");
        return TextUtils.isEmpty(userStr) ? null : (UserBean) GeneralUtils.toBean(userStr);
    }

    /**
     * 保存用户的个人认证信息
     */
    public void savePersonalInfo(PersonalInfo personalInfo) {
        saveData("personal_info", GeneralUtils.fromBean(personalInfo));
    }

    /**
     * 获取用户的个人认证信息
     */
    public PersonalInfo getPersonalInfo() {
        String objStr = getString("personal_info", "");
        return TextUtils.isEmpty(objStr) ? null : (PersonalInfo) GeneralUtils.toBean(objStr);
    }

    /**
     * 保存Gateway信息
     */
    public void saveGatewayInfo(GatewayInfoBean gatewayInfo) {
        saveData("gateway_info", GeneralUtils.fromBean(gatewayInfo));
    }

    /**
     * 获取Gateway信息
     */
    public GatewayInfoBean getGatewayInfo() {
        String objStr = getString("gateway_info", "");
        return TextUtils.isEmpty(objStr) ? null : (GatewayInfoBean) GeneralUtils.toBean(objStr);
    }

    /**
     * 更新政策 是否同意 状态
     */
    public void setPolicyStatus(boolean isAgreed) {
        saveData("has_agreed_policy", isAgreed);
    }

    /**
     * 是否已同意政策
     */
    public boolean hasAgreedPolicy() {
        return getBoolean("has_agreed_policy", false);
    }


    /**
     * 清除登录信息
     */
    public void clearLoginInfo() {
        saveData("user_info", "");
        saveData("token_info", "");
    }

    /**
     * 保存单条数据
     */
    public void saveData(String key, String data) {
        mEditor.putString(key, data);
        mEditor.commit();
    }

    /**
     * 保存单条数据(int)
     */
    public void saveData(String key, int data) {
        mEditor.putInt(key, data);
        mEditor.commit();
    }


    /**
     * 保存单条数据(boolean)
     */
    public void saveData(String key, boolean flag) {
        mEditor.putBoolean(key, flag);
        mEditor.commit();
    }

    /**
     * 保存多条数据
     */
    public void saveData(Map<String, String> map) {
        for (String key : map.keySet()) {
            mEditor.putString(key, map.get(key));
        }
        mEditor.commit();
    }

    /**
     * 根据key取指定字段
     */
    public String getString(String key, String defaultValue) {
        return mSharedPreferences.getString(key, defaultValue);
    }

    /**
     * 根据key取指定字段(int)
     */
    public int getInt(String key, int defaultValue) {
        return mSharedPreferences.getInt(key, defaultValue);
    }

    /**
     * 根据key取指定字段(boolean)
     */
    public boolean getBoolean(String key, boolean defaultValue) {
        return mSharedPreferences.getBoolean(key, defaultValue);
    }

    /**
     * 清除数据
     */
    public void clearAll() {
        mEditor = mSharedPreferences.edit();
        mEditor.clear();
        mEditor.commit();
    }

    /**
     * 查询某个key是否已经存在
     *
     * @param key
     * @return
     */
    public boolean contains(String key) {
        return mSharedPreferences.contains(key);
    }

}
