package com.common.activity;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;


import tech.starwin.LibConfig;
import tech.starwin.R;
import com.common.base.BaseActivity;
import com.common.bean.DisplayBean;
import tech.starwin.mvp.presenter.UserPresenter;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.ui_utils.QMUIHelper;
import com.common.widget.PageStateLayout;

/**
 * Created by SiKang on 2018/11/1.
 */
public class AboutUsActivity extends BaseActivity {
    TextView mAboutTv;
    PageStateLayout stateLayout;

    public static void start(Context context) {
        new ActivityJumper.Builder(context, AboutUsActivity.class).build().start();
    }


    @Override
    public int bindLayout() {
        return R.layout.actiivty_about_us;
    }

    @Override
    public void initView() {
        setTopBarTitle(getString(R.string.text_about));
        mAboutTv = findViewById(R.id.activity_about_us_tv);
        if (LibConfig.APP_ICON != 0) {
            ImageView logoImv = findViewById(R.id.activity_about_us_logo_imv);
            logoImv.setImageResource(LibConfig.APP_ICON);
            logoImv.setVisibility(View.VISIBLE);
        }
        stateLayout = QMUIHelper.bindEmptyView(mAboutTv, getString(R.string.text_temporarily_no_data), "Retry", new PageStateLayout.OnRetryListener() {
            @Override
            public void onRetry() {
                getPresenter(UserPresenter.class).getCustomerMsg("action_aboutUs");
            }
        });

        getPresenter(UserPresenter.class).getCustomerMsg("action_aboutUs");
    }

    @Override
    public void onHttpSuccess(String action, Object result) {
        if ("action_aboutUs".equals(action)) {
            DisplayBean displayBean = (DisplayBean) result;
            if (!TextUtils.isEmpty(displayBean.getDescription())) {
                mAboutTv.setText(displayBean.getDescription());
            } else {
                stateLayout.showEmpty();
            }
        }
    }
}
