# -*-coding:utf-8-*-
from func import Function
from shell import Shell
from tools.garble.api_garble import ApiGarble
from tools.garble.activity_garble import ActivityGarble
from tools.garble.string_garble import StringGarble
from tools.garble.package_garble import PackageGarble
from tools.garble.manifest_grable import ManifestGarble
from tools.garble.img_garble import ImageGarble
from tools.sdk_manager import SdkManager
from tools.garble.java_garble import JavaGarble
from tools.garble.layout_garble import LayoutGarble
import os
import shutil
import json

config_json = {}
with open("config.json", "r", encoding="utf-8") as fin:
    config_json = json.loads(fin.read())

properties = Function().load_properties("%s/gradle.properties"%config_json['root'])

config = config_json.copy()
config.update(properties)

config['jks_path'] = "../../jks"
config['apk_path'] = "../../resGuardApks/%s_%s_release.apk" % (
    config["corp_id"], config["app_name"].replace(" ", "_"))



print(" ")
print("------------- 使用帮助 -----------------")
print("1、编译apk")
print("2、修改包名，版本号+1")
print("3、创建新的签名文件")
print("4、commit & push project")
print("5、pull lib_base & cash_plugin_toolbox")
print("6、commit & push lib_base")
print("7、获取签名秘钥散列")
print("8、提交一个渠道包Tag")
print("9、还原某一次提交的包名、logo、gw、name、但保持最新代码")
print("10、更新Gateway")
print("11、copy apk")
print("12、马甲包切换")
print("13、打印checklist")
print("14、生成隐协议文件")
print("15、刷新本地协议")
print("16、api混淆")
print("17、字符串混淆")
print("18、四大组件混淆")
print("19、包路径混淆")
print("20、插入Activity")
print("21、reset project")
print("22、加固")
print("23、插入混淆图片")
print("24、插入混淆代码")
print("25、插入混淆layout")
print("26、启用/禁用代码")
print("27、签名SHA1")
print("28、安装apk到手机")


command = int(input("请输入指令编号："))

# 命令
if command == 1 or command == 111:
    # 注释通话记录代码
    SdkManager().start_process(config, False, "NOLOG")
    # 注释/开启 通讯录代码
    if config['contact'] == "true":
        SdkManager().start_process(config, True, "CONTACT")
    else:
        SdkManager().start_process(config, False, "CONTACT")
    # 布局文件混淆
    LayoutGarble().layout_garble(config)
    # api混淆
    ApiGarble().api_garble(config)
    # 字符串混淆
    StringGarble().str_grable(config)
    # 四大组件类名混淆
    ActivityGarble().activity_garble(config)
    # 包路径混淆
    PackageGarble().pkg_garble(config)
    # Manifest混淆
    ManifestGarble().manifest_garble(config)
    # 插入乱码
    JavaGarble().java_garble(config)
    # 图片混淆
    ImageGarble().img_garble(config)
   
    # 编译release
    Shell().build_release(config)
    Shell().reset_project(config)

elif command == 2:
    Function().new_appid(config)

elif command == 3:
    Function().new_keystore(config)

elif command == 4:
    Shell().push_project(config)

elif command == 5:
    Shell().pull_base(config)

elif command == 6:
    Shell().push_base(config)

elif command == 7:
    Function().getFbSign(config)

elif command == 8:
    Shell().push_with_tag(config)

elif command == 9:
    Shell().reset_by_pkgname(config)
    Function().move_resources(config)

elif command == 10:
    Function().update_gateway(config)

elif command == 11:
    Function().move_apk(config)

elif command == 12:
    Function().cutover(config)

elif command == 13 or command == 133:
    Function().print_checklist(config, command == 133)
    print("Api混淆、包路径全混淆、四大组件混淆、manifest混淆、随机插入乱码、随机插入Activity、字符串加密、随机插入字符串、随机插入图片、数据插入布局，现有布局加入干扰")
    print(" ")

elif command == 14:
    Function().new_privacy(config)

elif command == 15:
    Function().update_local_privacy(config)

elif command == 16:
    ApiGarble().api_garble(config)

elif command == 17:
    StringGarble().str_grable(config)

elif command == 18:
    ActivityGarble().activity_garble(config)

elif command == 19:
    PackageGarble().pkg_garble(config)

elif command == 20:
    ManifestGarble().manifest_garble(config)

elif command == 21:
    Shell().reset_project(config)

elif command == 22:
    Shell().jiagu(config)

elif command == 23:
    ImageGarble().img_garble(config)

elif command == 24:
    JavaGarble().java_garble(config)

elif command == 25:
    LayoutGarble().layout_garble(config)

elif command == 26:
    SdkManager().sdk_manage(config)

elif command == 27:
    Function().upate_keytore_sign(config)

elif command == 28:
    Shell().install_app(config)
