package tech.starwin.network;


import android.os.Build;
import android.text.TextUtils;

import com.common.toolbox.app_utils.DeviceInfo;
import com.common.toolbox.app_utils.RequestHandler;
import com.facebook.libfbref.FbDeepLink;

import java.io.IOException;
import java.util.HashMap;

import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import tech.starwin.LibConfig;
import tech.starwin.utils.LogUtils;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.context_utils.AppInfoUtils;

/**
 * Created by XLEO on 2018/1/30.
 */

public class FirebaseHeaderInterceptor implements Interceptor {
    public static final String TAG = "FirebaseHeaderInterceptor";

    @Override
    public Response intercept(Chain chain) throws IOException {

        Request request = chain.request();

        try {
            if (request != null) {
                Request.Builder builder = chain.request().newBuilder();

                String referrer = FbDeepLink.getFbReferrer();
                builder.addHeader("X-REFERRER", TextUtils.isEmpty(referrer) ? PreferencesManager.get().getInstallReferrer() : referrer)
                        .addHeader("X-REFERRER-SDK", TextUtils.isEmpty(referrer) ? PreferencesManager.get().getInstallReferrerFromSDK() : referrer)
                        .addHeader("X-ANDROID-ID", AppInfoUtils.getAndroidID(LibConfig.getContext()));

                String secretKey = PreferencesManager.get().getCustomerInfo().getRestUrlSignKey();

//                //取出post参数
//                HashMap<String, String> paramsMap = null;
//                if (request.body() instanceof FormBody) {
//                    FormBody body = (FormBody) request.body();
//                    paramsMap = new HashMap<>();
//                    for (int i = 0; i < body.size(); i++) {
//                        paramsMap.put(body.encodedName(i), body.encodedValue(i));
//                    }
//                }
//                //签名处理
//                RequestHandler handler = new RequestHandler.Builder(secretKey)
//                        .headerDeviceSign(DeviceInfo.getSignFromHardware())
//                        .headerSDSign(DeviceInfo.getDeviceSignFromSD())
//                        .parameters(request.url().toString(), paramsMap)
//                        .build();
//
//                //添加header
//                builder.addHeader("X-SD-SIGN", DeviceInfo.getDeviceSignFromSD()) //SD卡指纹
//                        .addHeader("X-DEVICE-SIGN", DeviceInfo.getSignFromHardware()) //设备指纹
//                        .addHeader("X-SDK-VERSION", String.valueOf(Build.VERSION.SDK_INT)) //Android SDK 版本
//                        .addHeader("X-HAEDWARE-INFO", DeviceInfo.getHardwareInfo()) //硬件信息
//                        .addHeader("X-APP-SIGN", handler.getHeaderSignature()) // Header 签名
//                        .addHeader("X-APP-RANDOM", handler.getRandom());// 随机串


                //header签名
                new RequestHandler.Builder(secretKey)
                        .headerDeviceSign(DeviceInfo.getSignFromHardware())
                        .headerSDSign(DeviceInfo.getDeviceSignFromSD())
                        .bindHttpBuilder(request,builder)
                        .build().signHeaders();

                request = builder.build();

                LogUtils.d("HttpHeaders", request.headers().toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
            //UploadManager.uploadException(e, "FirebaseHeaderInterceptor.intercept");
        }

        return chain.proceed(request);
    }

    private static boolean existHeader(Headers headers, String header) {
        if (headers == null || headers.names() == null || header == null || headers.size() == 0 || header.length() == 0) {
            return false;
        }

        return headers.names().contains(header);
    }

    private static String install_referrer_uploaded_key = "install_referrer_uploaded_key";
    private static String install_referrer_uploaded_with_token_key = "install_referrer_uploaded_with_token_key";


}
