package com.common.activity;

import android.content.Context;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;

import tech.starwin.R;

import com.common.base.BaseActivity;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import tech.starwin.utils.context_utils.ActivityJumper;

/**
 * Created by SiKang on 2018/11/19.
 */
public class WebActivity extends BaseActivity {
    public static void start(Context context, String title, String url) {
        new ActivityJumper.Builder(context, WebActivity.class)
                .put("title", title)
                .put("url", url)
                .build().start();
    }

    SmartRefreshLayout refreshLayout;
    WebView webView;


    @Override
    public int bindLayout() {
        return R.layout.activity_web;
    }

    @Override
    public void initView() {
        String url = getIntent().getStringExtra("url");
        String title = getIntent().getStringExtra("title");

        setTopBarTitle(title);
        refreshLayout = findViewById(R.id.activity_web_refresh);
        webView = findViewById(R.id.activity_web_wv);
        WebSettings setting = webView.getSettings();
        setting.setJavaScriptEnabled(true);//设置webview支持javascript脚本
        setting.setCacheMode(WebSettings.LOAD_NO_CACHE);//不加载缓存

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    refreshLayout.finishRefresh();
                }
            }
        });

        refreshLayout.setEnableLoadMore(false);
        refreshLayout.setOnRefreshListener(refreshLayout -> {
            WebStorage.getInstance().deleteAllData();//主动清除数据
            webView.loadUrl(getIntent().getStringExtra("url"));
        });

    }

    @Override
    protected void onStart() {
        super.onStart();
        refreshLayout.autoRefresh();
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
