package tech.starwin.widget;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;

import com.qmuiteam.qmui.widget.dialog.QMUITipDialog;

import tech.starwin.utils.ui_utils.DialogFactory;


/**
 * Created by SiKang on 2018/9/19.
 * 请求进度Dialog，用于展示Loading 或 错误信息
 */
public class ProgressDialog {
    //loading dialog
    private Dialog loadingDialog;
    private Context context;

    public ProgressDialog(@NonNull Context context) {
        this.context = context;
        this.loadingDialog = new LoadingDialog(context);
    }

    public ProgressDialog(@NonNull Dialog loadingDialog) {
        this.context = loadingDialog.getContext();
        this.loadingDialog = loadingDialog;
    }


    public void showLoading() {
        if (!loadingDialog.isShowing()) {
            loadingDialog.show();
        }
    }

    public void dissmissLoading() {
        if (loadingDialog.isShowing()) {
            loadingDialog.dismiss();
        }
    }

    /**
     * 关闭loading 显示错误提示
     * */
    @SuppressLint("CheckResult")
    public void showError(String msg) {
        final Dialog errorDialog = DialogFactory.createTipDialog(context, QMUITipDialog.Builder.ICON_TYPE_FAIL, msg);
        if (loadingDialog.isShowing())
            loadingDialog.dismiss();
        DialogFactory.showTiming(errorDialog, 1500);
    }


}
