#!/usr/bin/env python3
import json
import string
import random
import glob, os
import sys


def addToProperties(code):
    path = "../../../gradle.properties"

    with open(path, "r", encoding="utf-8") as f:
        lines = f.readlines()

    with open(path, "w", encoding="utf-8") as f_w:
        for line in lines:
            if code in line:
                line = "#"+line
            if "#MARK-END" in line:
                line = code + "\n" + line
            f_w.write(line)

def needChange(code,line):
    return  code in line and "${" not in line

def getResValue(line):
    return line.split(",")[2].replace("\\\"","").replace("\"","").replace("'","").replace(" ","").replace(")","").replace("\n","")

def getStringFiled(key,value):
    return "\t\t\tbuildConfigField 'String', '" + key + "', " + value + "\n"

def getColorRes(key,value):
    return "\t\t\tresValue('color', '"+key+"', " + value + ")\n"

def getStringRes(key,value):
    return "\t\t\tresValue('string', '"+key+"', " + value + ")\n"

def move_config(path):
    # print("processing content: %s..." % path)
    with open(path, "r", encoding="utf-8") as f:
        # readlines以列表的形式将文件读出
        lines = f.readlines()
    move_finished=0
    with open(path, "w", encoding="utf-8") as f_w:
        for line in lines:
            if "product {" in line:
                move_finished += 1
            if move_finished == 1 and "}" in line:
                move_finished +=1
            if move_finished >1:
                f_w.write(line)
                continue


            if needChange("app_name_str",line):
                addToProperties("app_name="+getResValue(line))
                line = getStringRes("app_name_str","\"${app_name}\"")

            elif needChange("LANGUAGE",line):
                if line.startswith("//"):
                    line = ""
                else:
                    addToProperties("\n#语言 in / zh / en")
                    addToProperties("language=\"in\"")
                    line = getStringFiled("LANGUAGE","\"${language}\"")

            elif needChange("main_color",line):
                addToProperties("main_color="+getResValue(line))
                line = getColorRes("main_color","\"${main_color}\"")

            elif needChange("main_text_color",line):
                addToProperties("main_text_color="+getResValue(line))
                line = getColorRes("main_text_color","\"${main_text_color}\"")

            elif needChange("FACEBOOK_APP_ID",line):
                addToProperties("\n#Accoubt Kit")
                addToProperties("facebook_app_id="+getResValue(line))
                line = getStringRes("FACEBOOK_APP_ID","\"${facebook_app_id}\"")

            elif needChange("ACCOUNT_KIT_CLIENT_TOKEN",line):
                addToProperties("account_kit_client_token="+getResValue(line))
                line = getStringRes("ACCOUNT_KIT_CLIENT_TOKEN","\"${account_kit_client_token}\"")


            elif needChange("ZENDESK_URL",line):
                addToProperties("\n#zendesk 客服")
                addToProperties("zendesk_url=\""+getResValue(line)+"\"")
                line = getStringFiled("ZENDESK_URL","\"${zendesk_url}\"")

            elif needChange("ZENDESK_APP_ID",line):
                addToProperties("zendesk_app_id=\""+getResValue(line)+"\"")
                line = getStringFiled("ZENDESK_APP_ID","\"${zendesk_app_id}\"")

            elif needChange("ZENDESK_CLIENT_ID",line):
                addToProperties("zendesk_client_id=\""+getResValue(line)+"\"")
                line = getStringFiled("ZENDESK_CLIENT_ID","\"${zendesk_client_id}\"")

            elif needChange("APPSFLYER_DEV_KEY",line):
                addToProperties("\n#Appsflyer")
                addToProperties("appsflyer_key=\""+getResValue(line)+"\"")
                line = getStringFiled("APPSFLYER_DEV_KEY","\"${appsflyer_key}\"")

            elif needChange("HOTLINE",line):
                addToProperties("\n#客服电话")
                addToProperties("hot_line=\""+getResValue(line)+"\"")
                line = getStringFiled("HOTLINE","\"${hot_line}\"")

            elif needChange("API_BASE_URL",line):
                addToProperties("\n#server")
                addToProperties("base_url=\""+getResValue(line)+"\"")
                line = getStringFiled("API_BASE_URL","\"${base_url}\"")

            elif needChange("HARVESTER_IP",line):
                addToProperties("harvest_ip=\""+getResValue(line)+"\"")
                line = getStringFiled("HARVESTER_IP","\"${harvest_ip}\"")

            elif needChange("HARVESTER_PORT",line):
                addToProperties("harvest_port="+getResValue(line))
                line = "\t\t\tbuildConfigField 'int', 'HARVESTER_PORT', \"${harvest_port}\"\n"

            elif needChange("GATEWAY_HOST_G0",line):
                addToProperties("gateway_url=\""+getResValue(line)+"\"")
                line = getStringFiled("GATEWAY_HOST_G0","\"${gateway_url}\"")

            elif needChange("GATEWAY_HOST_G1",line):
                addToProperties("gateway_ip=\""+getResValue(line)+"\"")
                line = getStringFiled("GATEWAY_HOST_G1","\"${gateway_ip}\"")

            elif needChange("REPAYMENT_H5",line):
                addToProperties("repayment_h5=\""+getResValue(line)+"\"")
                line = getStringFiled("REPAYMENT_H5","\"${repayment_h5}\"")

            elif needChange("ADMIN_HOST",line):
                addToProperties("admin_host=\""+getResValue(line)+"\"")
                line = getStringFiled("ADMIN_HOST","\"${admin_host}\"")

            elif needChange("AGREEMENT_URL",line):
                addToProperties("agreement_url=\""+getResValue(line)+"\"")
                line = getStringFiled("AGREEMENT_URL","\"${agreement_url}\"")
                
                
            f_w.write(line)
    return


move_config("../../../app/app_config.gradle")