package tech.starwin;

import android.app.Application;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.view.View;

import com.meituan.android.walle.WalleChannelReader;
import com.scwang.smartrefresh.header.MaterialHeader;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.DefaultRefreshFooterCreator;
import com.scwang.smartrefresh.layout.api.DefaultRefreshHeaderCreator;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;


import cn.fraudmetrix.octopus.aspirit.main.OctopusManager;

import tech.starwin.network.Gateway;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.ScreenAutoSize;
import tech.starwin.utils.collection.UploadManager;
import tech.starwin.utils.context_utils.AppInfoUtils;
import zendesk.core.AnonymousIdentity;
import zendesk.core.Zendesk;
import zendesk.support.Support;

/**
 * Created by SiKang on 2018/9/30.
 * 配置 BaseLibrary
 */
public class LibConfig {
    /**
     * BuildConfig 数据
     */
    private static Application CONTEXT;
    public static boolean DEBUG;
    public static String APP_NAME;
    public static String APPLICATION_ID;
    public static String BUILD_TYPE;
    public static String FLAVOR;
    public static int VERSION_CODE;
    public static String VERSION_NAME;
    public static String LOGIN_ACTIVITY_ACTION;
    public static String FLAVOR_default;
    public static String FLAVOR_server;
    public static String AGREEMENT_URL;
    public static String REPAYMENT_H5;
    public static String APP_URL;
    public static String BUGLY_APP_ID;
    public static String PRIVACY_POLICY;
    public static String HOTLINE;
    public static String LOAN_AGREEMENT;
    public static String ROOT_DIR;
    public static String ADMIN_HOST;
    public static String API_BASE_URL;
    public static String GATEWAY_HOST_G0;
    public static String GATEWAY_HOST_G1;
    public static String HARVESTER_IP;
    public static String ZENDESK_URL;
    public static String ZENDESK_APP_ID;
    public static String ZENDESK_OAUTH_CLIENT_ID;
    public static String TONGDUN_PARENT_CODE;
    public static String TONGDUN_PARENT_KEY;
    public static String TONGDUN_DEVICE_PARENT_CODE;
    public static String TONGDUN_APP_NAME;
    public static String APPSFLYER_DEV_KEY;
    public static String XH_CHANNEL_NAME;
    public static boolean IS_COLLECT_MODE;
    public static boolean LOAD_BUGLY = false;
    public static String TEST_TOKEN;
    public static String LANGUAGE = "in";
    public static int HARVESTER_PORT;//
    public static int LOADING_ICON;//loading图标
    public static int LOADING_BACKGROUND;//loading旋转背景
    public static int APP_ICON = R.mipmap.ic_launcher;
    public static int MAIN_COLOR = R.color.qmui_config_color_blue;//主题色

    public static ButterKnifeBinder butterKnifeBinder;

    public static Application getContext() {
        if (CONTEXT == null)
            throw new RuntimeException("context is null ! you must execute LibConfig.initLib(context) in your Appliaction");
        return CONTEXT;
    }


    /**
     * 初始化 BaseLibrary
     */
    public static void initLib(Application application) {
        if (application != null) {
            CONTEXT = application;
            String channel = WalleChannelReader.getChannel(application.getApplicationContext());
            if (!TextUtils.isEmpty(channel)) {
                XH_CHANNEL_NAME = channel;
            }


            //APP名字
            LibConfig.APP_NAME = AppInfoUtils.getAppName(CONTEXT);
            if (TextUtils.isEmpty(LibConfig.ROOT_DIR)) {
                LibConfig.ROOT_DIR = LibConfig.APP_NAME;
            }


            //SDK-CHANNEL-START
//SDK-CHANNEL-CODE	            com.mixpanel.android.mpmetrics.MixpanelAPI.getInstance(application, "8d7cc843b3c027ccab6288e55d99edbc");
//SDK-CHANNEL-CODE	            com.kochava.base.Tracker.configure(new com.kochava.base.Tracker.Configuration(application)
//SDK-CHANNEL-CODE	                    .setAppGuid("kobackup-master-oxv8ltm")
//SDK-CHANNEL-CODE	            );
//SDK-CHANNEL-CODE	            //SDK-CHANNEL-END


            //屏幕适配（360dp宽度限定）
            ScreenAutoSize.resizeDensity(CONTEXT, 360f);


            //上传工具
            UploadManager.init(CONTEXT);

            //TODO - FireBase配置
            //init FireBase
//            FirebaseApp.initializeApp(CONTEXT);


            //init SharePreferences
            PreferencesManager.get().init(CONTEXT);

            //init gateway
            Gateway.init(PreferencesManager.get().getGatewayInfo());

            //init zendesk
            initZendesk(CONTEXT);

            initTD();
        }

    }


    /**
     * init FirebaseRemoteConfig 1
     */
//    private static void initFirebaseRemoteConfig() {
//        FirebaseRemoteConfig.getInstance().setConfigSettings(
//                new FirebaseRemoteConfigSettings.Builder()
//                        .setDeveloperModeEnabled(LibConfig.DEBUG)
//                        .build()
//        );
//        TrackEventHelper.fetchRemoteConfig();
//    }


    /**
     * init zendesk
     */
    private static void initZendesk(Application application) {
        if (!TextUtils.isEmpty(ZENDESK_URL) && !TextUtils.isEmpty(ZENDESK_APP_ID) && !TextUtils.isEmpty(ZENDESK_OAUTH_CLIENT_ID)) {
            Zendesk.INSTANCE.init(application, ZENDESK_URL, ZENDESK_APP_ID, ZENDESK_OAUTH_CLIENT_ID);
            Support.INSTANCE.init(Zendesk.INSTANCE);
            Zendesk.INSTANCE.setIdentity(new AnonymousIdentity());//匿名身份
        }
    }

    /**
     * init 同盾
     */

    private static void initTD() {
        if (!TextUtils.isEmpty(TONGDUN_PARENT_CODE) && !TextUtils.isEmpty(TONGDUN_PARENT_KEY)) {
            OctopusManager.getInstance().init(CONTEXT, TONGDUN_PARENT_CODE, TONGDUN_PARENT_KEY, TONGDUN_APP_NAME);
            OctopusManager.getInstance().setPrimaryColorResId(MAIN_COLOR);
            OctopusManager.getInstance().setTitleColorResId(R.color.white);
            OctopusManager.getInstance().setShowWarnDialog(true);
            OctopusManager.getInstance().setStatusBarBg(MAIN_COLOR);
        }
    }


    /**
     * 用于在Base 中 实现Butterknife.bind()的功能
     *
     * @param binder 实现 ButterKnifeBinder.bindView() 方法，在其中做Butterknife.bind() ，功能
     */
    public static void setButterKnifeBinder(ButterKnifeBinder binder) {
        butterKnifeBinder = binder;
    }

    public static Object bindView(Object obj, View view) {
        if (butterKnifeBinder != null) {
            return butterKnifeBinder.bindView(obj, view);
        }
        return null;
    }

    public static void unBindView(Object unBinder) {
        if (butterKnifeBinder != null) {
            butterKnifeBinder.unBind(unBinder);
        }
    }

    public interface ButterKnifeBinder {
        Object bindView(Object obj, View view);

        void unBind(Object obj);
    }

    /**
     * SmartRefresh 默认风格
     * */
    static {
        //设置全局的Header构建器
        SmartRefreshLayout.setDefaultRefreshHeaderCreator(new DefaultRefreshHeaderCreator() {
            @Override
            public RefreshHeader createRefreshHeader(Context context, RefreshLayout layout) {
                layout.setPrimaryColorsId(R.color.qmui_config_color_gray_9, R.color.qmui_config_color_50_pure_black);//全局设置主题颜色
                return new MaterialHeader(context);//.setTimeFormat(new DynamicTimeFormat("更新于 %s"));//指定为经典Header，默认是 贝塞尔雷达Header
            }
        });
        //设置全局的Footer构建器
        SmartRefreshLayout.setDefaultRefreshFooterCreator(new DefaultRefreshFooterCreator() {
            @Override
            public RefreshFooter createRefreshFooter(Context context, RefreshLayout layout) {
                //指定为经典Footer，默认是 BallPulseFooter
                return new ClassicsFooter(context).setDrawableSize(20);
            }
        });
    }

}
