/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class WalleCommandLine {
    @Parameter(names={"-v", "--version"}, description="show walle version")
    private boolean showVersion;
    @Parameter(names={"-h", "--help"}, description="show walle command line help")
    private boolean showHelp;

    public void parse(JCommander commander) {
        if (this.showVersion) {
            System.out.println(WalleCommandLine.getVersion());
            return;
        }
        if (this.showHelp) {
            commander.usage();
        }
    }

    private static String getVersion() {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    Manifest manifest;
                    Attributes mainAttribs;
                    String version;
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is == null || (version = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue("Walle-Version")) == null) continue;
                    return version;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }
}

