#!/usr/bin/env bash
cd ../../
. gradle.properties
echo -n "enter the new keystore name (last version :${signing_keyAlias}) : "
read newKeyName

#输入 v** 直接改版本号，否则修改全名
if [[ ${newKeyName:0:1} = 'v' ]]
then
    oldIFS=$IFS
    IFS=_
    array=(${signing_keyAlias})
    alias="${array[0]}_${newKeyName}"
else
    alias=${newKeyName}
fi

certificate="../jks/${alias}.keystore"
certificatePassword=${alias}
storePassword=${alias}

sed -i "" "s#^signing_keyAlias=.*#signing_keyAlias=${alias}#g"  gradle.properties
sed -i "" "s#^signing_certificate=.*#signing_certificate=${certificate}#g"  gradle.properties
sed -i "" "s#^signging_certificatePassword=.*#signging_certificatePassword=${certificatePassword}#g"  gradle.properties
sed -i "" "s#^signging_storePassword=.*#signging_storePassword=${storePassword}#g"  gradle.properties

echo "ready to create new kestore ${alias}"
keytool -genkey -alias "${alias}" -keyalg RSA -validity 20000 -keystore jks/"${alias}".keystore