package tech.starwin.mvp.ui.activity;

import android.content.Context;
import android.support.v7.widget.RecyclerView;

import java.util.List;

import tech.starwin.R;
import tech.starwin.base.BaseActivity;
import tech.starwin.mvp.beans.ActivityInfoBean;
import tech.starwin.mvp.presenter.UserPresenter;
import tech.starwin.mvp.ui.adapter.EventCenterAdapter;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2018/11/20.
 */
public class ActivityCenter extends BaseActivity {

    public static void start(Context context) {
        new ActivityJumper.Builder(context, ActivityCenter.class).build().start();
    }

    @Override
    public int bindLayout() {
        return R.layout.simple_recyclerview;
    }

    @Override
    public void initView() {
        setTopBarTitle(getString(R.string.text_activity_center));
        getPresenter(UserPresenter.class).getActivitys("action_getActivitys");
    }

    @Override
    public void onHttpSuccess(String action, Object result) {
        RecyclerView recyclerView = findViewById(R.id.simple_recyclerview);
        List<ActivityInfoBean> activityList = (List<ActivityInfoBean>) result;
        EventCenterAdapter adapter = new EventCenterAdapter(ActivityCenter.this, activityList);
        UIHelper.bindAdapter(recyclerView, adapter);

    }
}
