package tech.starwin.utils.ui_utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.qmuiteam.qmui.util.QMUIStatusBarHelper;
import com.qmuiteam.qmui.widget.QMUIEmptyView;
import com.qmuiteam.qmui.widget.QMUITabSegment;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.grouplist.QMUICommonListItemView;
import com.qmuiteam.qmui.widget.grouplist.QMUIGroupListView;

import tech.starwin.R;
import tech.starwin.utils.BitmapUtils;
import tech.starwin.utils.format_utils.StringFormat;
import tech.starwin.widget.PageStateLayout;
import tech.starwin.widget.TopBar;

/**
 * Created by SiKang on 2018/10/12.
 * QMUI辅助类
 */
public class QMUIHelper {
    private static TopbarCustomizer topbarCustomizer;

    /**
     * 重新设置topbarimagebutton的图片尺寸
     * 当没有合适尺寸的图片使用时，将图片强制缩放到适合的尺寸
     */
    public static ImageButton resizeTopbarBtn(ImageButton imageButton) {
        int width = StringFormat.dpToPx(imageButton.getContext(), 17f);
        Bitmap bmp = BitmapUtils.drawableToBmp(imageButton.getDrawable());
        imageButton.setImageBitmap(BitmapUtils.scaleBitmap(bmp, width, width));
        imageButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        return imageButton;
    }

    /**
     * 为一个View 套一个 EmptyView外壳，用于展示无数据和重试的情况
     *
     * @param targetView 需要套壳，加入状态显示的View
     * @param emptyText  没有数据时的提示文字
     * @param retryText  重试按钮的文字
     * @param listener   当pageStateLayout.retry() 被执行时的刷新处理
     */
    public static PageStateLayout bindEmptyView(View targetView, final String emptyText, final String retryText, PageStateLayout.OnRetryListener listener) {
        //创建一个默认的EmptyView
        final QMUIEmptyView emptyView = new QMUIEmptyView(targetView.getContext());
        emptyView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        emptyView.setBackgroundColor(Color.WHITE);

        //给targetView 套壳
        final PageStateLayout pageStateLayout = new PageStateLayout.Builder(targetView)
                .setStateView(emptyView)
                .setOnRetryListener(listener)
                .create();
        //不同状态的UI处理
        pageStateLayout.setOnStateChangedListener(new PageStateLayout.OnStateChangedListener() {
            @Override
            public void onLoading(PageStateLayout.ViewHolder holder) {
                emptyView.show(true);
            }

            @Override
            public void onError(PageStateLayout.ViewHolder holder) {

            }

            @Override
            public void onEmpty(PageStateLayout.ViewHolder holder) {
                emptyView.show(false, emptyText, null, retryText, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        pageStateLayout.retry();
                    }
                });
            }
        });
        return pageStateLayout;
    }

    /**
     * 创建一个(icon + text)类型的Tab按钮
     */
    public static QMUITabSegment.Tab createTab(Context context, @DrawableRes int normalIcon, @DrawableRes int selectIcon, String text) {
        return new QMUITabSegment.Tab(
                ContextCompat.getDrawable(context, normalIcon),
                ContextCompat.getDrawable(context, selectIcon),
                text, false
        );
    }

    /**
     * 创建一个(icon + text)类型的Tab按钮，并按指定尺寸显示icon
     */
    public static QMUITabSegment.Tab createTab(Context context, int iconWidtn, int iconHeight, @DrawableRes int normalIcon, @DrawableRes int selectIcon, String text) {
        Bitmap normalBitmap = BitmapFactory.decodeResource(context.getResources(),
                normalIcon);
        Bitmap selectBitmap = BitmapFactory.decodeResource(context.getResources(),
                selectIcon);

        Drawable normalDrawble = new BitmapDrawable(BitmapUtils.scaleBitmap(normalBitmap, iconWidtn, iconHeight));
        Drawable selectDrawble = new BitmapDrawable(BitmapUtils.scaleBitmap(selectBitmap, iconWidtn, iconHeight));

        return new QMUITabSegment.Tab(normalDrawble, selectDrawble, text, false);
    }


    /**
     * 创建一个(text)类型的Tab按钮
     */
    public static QMUITabSegment.Tab createTab(String text) {
        return new QMUITabSegment.Tab(text);
    }


    /**
     * 创建一个只包含 Text 的item按钮
     */
    public static QMUICommonListItemView createItemView(int id, QMUIGroupListView groupListView, @StringRes int titleId) {
        return createChevronItemView(id, groupListView, groupListView.getContext().getString(titleId));
    }

    public static QMUICommonListItemView createItemCiew(int id, QMUIGroupListView groupListView, String title) {
        QMUICommonListItemView itemWithChevron = groupListView.createItemView(title);
        itemWithChevron.setId(id);
        return itemWithChevron;
    }

    /**
     * 创建一个 Text + 右箭头的 item按钮
     */
    public static QMUICommonListItemView createChevronItemView(int id, QMUIGroupListView groupListView, @StringRes int titleId) {
        return createChevronItemView(id, groupListView, groupListView.getContext().getString(titleId));
    }

    public static QMUICommonListItemView createChevronItemView(int id, QMUIGroupListView groupListView, String title) {
        QMUICommonListItemView itemWithChevron = createItemCiew(id, groupListView, title);
        itemWithChevron.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CHEVRON);
        return itemWithChevron;
    }


    /**
     * 向一个ViewGroup 插入一个TopBar
     */
    public static TopBar insertTopBar(ViewGroup viewGroup, boolean isTransParentStatusBar) {
        TopBar topBar = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.base_topbar, viewGroup, true).findViewById(R.id.topbar);
        //如果开启沉浸式状态栏，则获取状态栏高度，并将TopBar增加相应的高度
        if (isTransParentStatusBar) {
            topBar.setStatusBarHeight(QMUIStatusBarHelper.getStatusbarHeight(viewGroup.getContext()));
        }
        if (topbarCustomizer != null) {
            topbarCustomizer.madeTopBar(topBar);
        }
        return topBar;
    }


    public static void setTopbarCustomizer(TopbarCustomizer customizer) {
        topbarCustomizer = customizer;
    }

    /**
     * TopBar默认样式定制
     */
    public interface TopbarCustomizer {
        //        void madeTopBar(ViewGroup titleGroup, QMUITopBar topBar);
        void madeTopBar(TopBar topBar);
    }

}
