#!/usr/bin/env python3
import json
import string
import random
import glob, os
import sys

used_names = []


# rand string for class names
def gen_rand_str():
    rand_str = ''.join(random.choices(string.ascii_uppercase + string.ascii_lowercase, k=8))
    while rand_str in used_names:
        rand_str = ''.join(random.choices(string.ascii_uppercase + string.ascii_lowercase, k=8))

    used_names.append(rand_str)
    return rand_str + str(random.randint(0, 1000))


def get_rand_code(isInFunc):
    indentasi = random.randint(0, 5);
    indentasiStr = ""
    for num in range(0, indentasi):
        indentasiStr += "\t"

    # 随机缩进
    num = random.randint(0, 4);
    code = ";\n"
    filedName = gen_rand_str()
    # 随机代码
    if num == 0:
        code += indentasiStr + "String " + filedName + "=\"" + gen_rand_str() + "\";\n"
    elif num == 1:
        code += indentasiStr + "int " + filedName + "=" + str(random.randint(0, 100000)) + ";\n"
    elif num == 2:
        code += indentasiStr + "float " + filedName + "=" + str(random.randint(0, 100000)) + ";\n"
    elif num == 3:
        code += indentasiStr + "double " + filedName + "=" + str(random.randint(0, 100000)) + ";\n"
    elif num == 4:
        code += indentasiStr + "long " + filedName + "=" + str(random.randint(0, 100000)) + ";\n"

    if isInFunc:
        if num == 0:
            code += "if(\"" + filedName + "\".equals(\"" + gen_rand_str() + "\")){}//interference code\n"
        else:
            index = gen_rand_str()
            code += "for(int " + index + "="+str(random.randint(0,10))+";"+index+"<"+filedName+";"+index+"++){}//interference code\n"

    return code



def process_file_content(path, file_name):
    # print("processing content: %s..." % path)
    with open(path, "r", encoding="utf-8") as f:
        # readlines以列表的形式将文件读出
        lines = f.readlines()

    with open(path, "w", encoding="utf-8") as f_w:
        isReturn = False
        isErrorIf = False
        return_level = 0
        func_level = 0
        isAbstract = False
        for line in lines:
            if "interface" in line or "abstract" in line:
                isAbstract=True
            if isAbstract:
                f_w.write(line)
                continue

            #没加{}的if else
            if ("if(" in line or "if (" in line) and "{" not in line:
                isErrorIf = True
            #return后有多行代码
            if "return" in line or "throw" in line and not isReturn:
                isReturn = True
                return_level = 0

            if isReturn:
                if "{" in line:
                    return_level += 1
                elif "}" in line:
                    return_level -= 1
                    if return_level < 0:
                        return_level = 0


            if "//interference code" not in line and \
                    ("){\n" in line or ") {\n" in line) and \
                    func_level == 0 and \
                    not isReturn:
                func_level = 1
            elif func_level > 0:
                if "//interference code" not in line and "{\n" in line:
                    func_level +=1
                if "//interference code" not in line and "}\n" in line:
                    func_level -=1
                    if return_level < 0:
                        return_level = 0


            #需要忽略的行
            if not isReturn and not isErrorIf and \
                    ";\n" in line and \
                    "return" not in line and \
                    "break" not in line and \
                    "continue" not in line and \
                    "import" not in line and \
                    "package" not in line and \
                    "throw" not in line and \
                    "};" not in line and \
                    "});" not in line and \
                    "//" not in line:

                if random.randint(0, 20) % 2 == 0:
                    line = line.replace(";\n", get_rand_code(func_level>0))

            if ";" in line :
                isErrorIf = False

            if ";\n" in line and return_level == 0:
                isReturn = False

            f_w.write(line)
        # print("done\n")
    return


# perform content replace for the files
for root, dirs, files in os.walk("../../../app/src/main"):
    directory = os.path.join(os.getcwd(), root)
    for file in files:
        if file.endswith(".java"):
            # get the path of the java file
            path = os.path.join(directory, file)

            process_file_content(path, file)

for root, dirs, files in os.walk("../../../lib_base/src/main"):
    directory = os.path.join(os.getcwd(), root)
    for file in files:
        if file.endswith(".java"):
            # get the path of the java file
            path = os.path.join(directory, file)

            process_file_content(path, file)

print("processing file content done")
