package tech.starwin.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.DrawerLayout;
import android.util.AttributeSet;
import android.view.MotionEvent;


/**
 * Created by SiKang on 2018/11/15.
 * 首页UI的布局设计中，页面内容的尺寸是大于DrawerLayout的，所以无法将Content放在DrawerLayout中，只能将Drawer覆盖在Content上，而这样又会导致Touch事件冲突，Content无法收到Touch事件
 * 所以这里使用了PenetrateDrawerLayout来放行Touch事件，在Drawer处理完 Touch 事件后主动放行，让Content能够继续处理事件
 */
public class PenetrateDrawerLayout extends DrawerLayout {
    public PenetrateDrawerLayout(@NonNull Context context) {
        super(context);
    }

    public PenetrateDrawerLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PenetrateDrawerLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
//        switch (ev.getAction()) {
//            case MotionEvent.ACTION_DOWN:
//                LogUtils.d("TouchTest", "Drawer: ACTION_DOWN");
//                break;
//            case MotionEvent.ACTION_MOVE:
//                LogUtils.d("TouchTest", "Drawer: ACTION_MOVE");
//                break;
//            case MotionEvent.ACTION_CANCEL:
//                LogUtils.d("TouchTest", "Drawer: ACTION_CANCEL");
//                break;
//            case MotionEvent.ACTION_UP:
//                LogUtils.d("TouchTest", "Drawer: ACTION_UP");
//                break;
//        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        return false;
    }
}
